/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.lib.com.github.retrooper.packetevents.protocol.particle.data;

import com.jtprince.lib.com.github.retrooper.packetevents.protocol.color.Color;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.particle.data.ParticleData;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.jtprince.lib.com.github.retrooper.packetevents.util.Vector3d;
import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.PacketWrapper;

public class ParticleTrailData
extends ParticleData {
    private Vector3d target;
    private Color color;

    public ParticleTrailData(Vector3d target, Color color) {
        this.target = target;
        this.color = color;
    }

    public static ParticleTrailData read(PacketWrapper<?> wrapper) {
        Vector3d target = Vector3d.read(wrapper);
        Color color = new Color(wrapper.readInt());
        return new ParticleTrailData(target, color);
    }

    public static void write(PacketWrapper<?> wrapper, ParticleTrailData data) {
        Vector3d.write(wrapper, data.target);
        wrapper.writeInt(data.color.asRGB());
    }

    public static ParticleTrailData decode(NBTCompound compound, ClientVersion version) {
        Vector3d target = Vector3d.decode(compound.getTagOrThrow("target"), version);
        Color color = Color.decode(compound.getTagOrThrow("color"), version);
        return new ParticleTrailData(target, color);
    }

    public static void encode(ParticleTrailData data, ClientVersion version, NBTCompound compound) {
        compound.setTag("target", Vector3d.encode(data.target, version));
        compound.setTag("color", Color.encode(data.color, version));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public Vector3d getTarget() {
        return this.target;
    }

    public void setTarget(Vector3d target) {
        this.target = target;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

