/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.lib.com.github.retrooper.packetevents.protocol.player;

import com.jtprince.lib.com.github.retrooper.packetevents.PacketEvents;
import com.jtprince.lib.com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.jtprince.lib.com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.ConnectionState;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.chat.ChatType;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.chat.ChatTypes;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.chat.message.ChatMessage;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.chat.message.ChatMessageLegacy;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.chat.message.ChatMessage_v1_16;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.nbt.NBTList;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.Dimension;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.dimension.DimensionType;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.dimension.DimensionTypes;
import com.jtprince.lib.com.github.retrooper.packetevents.resources.ResourceLocation;
import com.jtprince.lib.com.github.retrooper.packetevents.util.adventure.AdventureSerializer;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.IRegistry;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.IRegistryHolder;
import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerChatMessage;
import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerCloseWindow;
import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetTitleSubtitle;
import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetTitleText;
import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetTitleTimes;
import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSystemChatMessage;
import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerTitle;
import com.jtprince.lib.net.kyori.adventure.text.Component;
import com.jtprince.lib.org.jetbrains.annotations.ApiStatus;
import com.jtprince.lib.org.jetbrains.annotations.Nullable;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class User
implements IRegistryHolder {
    private final Object channel;
    private ConnectionState decoderState;
    private ConnectionState encoderState;
    private ClientVersion clientVersion;
    private final UserProfile profile;
    private int entityId = -1;
    private DimensionType dimensionType = DimensionTypes.OVERWORLD;
    private final Map<ResourceLocation, IRegistry<?>> registries = new HashMap();

    public User(Object channel, ConnectionState connectionState, ClientVersion clientVersion, UserProfile profile) {
        this.channel = channel;
        this.decoderState = connectionState;
        this.encoderState = connectionState;
        this.clientVersion = clientVersion;
        this.profile = profile;
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public IRegistry<?> getRegistry(ResourceLocation registryKey, ClientVersion version) {
        return this.registries.get(registryKey);
    }

    @ApiStatus.Internal
    public void putRegistry(IRegistry<?> registry) {
        this.registries.put(registry.getRegistryKey(), registry);
    }

    public Object getChannel() {
        return this.channel;
    }

    public InetSocketAddress getAddress() {
        return (InetSocketAddress)ChannelHelper.remoteAddress(this.channel);
    }

    public ConnectionState getConnectionState() {
        ConnectionState decoderState = this.decoderState;
        ConnectionState encoderState = this.encoderState;
        if (decoderState != encoderState) {
            throw new IllegalArgumentException("Can't get common connection state: " + (Object)((Object)decoderState) + " != " + (Object)((Object)encoderState));
        }
        return decoderState;
    }

    public void setConnectionState(ConnectionState connectionState) {
        this.setDecoderState(connectionState);
        this.setEncoderState(connectionState);
    }

    public ConnectionState getDecoderState() {
        return this.decoderState;
    }

    public void setDecoderState(ConnectionState decoderState) {
        this.decoderState = decoderState;
        PacketEvents.getAPI().getLogManager().debug("Transitioned " + this.getName() + "'s decoder into " + (Object)((Object)decoderState) + " state!");
    }

    public ConnectionState getEncoderState() {
        return this.encoderState;
    }

    public void setEncoderState(ConnectionState encoderState) {
        this.encoderState = encoderState;
        PacketEvents.getAPI().getLogManager().debug("Transitioned " + this.getName() + "'s encoder into " + (Object)((Object)encoderState) + " state!");
    }

    public ClientVersion getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(ClientVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    public UserProfile getProfile() {
        return this.profile;
    }

    public String getName() {
        return this.profile.getName();
    }

    public UUID getUUID() {
        return this.profile.getUUID();
    }

    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void sendPacket(Object buffer) {
        PacketEvents.getAPI().getProtocolManager().sendPacket(this.channel, buffer);
    }

    public void sendPacket(PacketWrapper<?> wrapper) {
        PacketEvents.getAPI().getProtocolManager().sendPacket(this.channel, wrapper);
    }

    public void sendPacketSilently(PacketWrapper<?> wrapper) {
        PacketEvents.getAPI().getProtocolManager().sendPacketSilently(this.channel, wrapper);
    }

    public void writePacket(PacketWrapper<?> wrapper) {
        PacketEvents.getAPI().getProtocolManager().writePacket(this.channel, wrapper);
    }

    public void flushPackets() {
        ChannelHelper.flush(this.channel);
    }

    public void closeConnection() {
        ChannelHelper.close(this.channel);
    }

    public void closeInventory() {
        WrapperPlayServerCloseWindow closeWindow = new WrapperPlayServerCloseWindow(0);
        PacketEvents.getAPI().getProtocolManager().sendPacket(this.channel, closeWindow);
    }

    public void sendMessage(String legacyMessage) {
        Component component = AdventureSerializer.fromLegacyFormat(legacyMessage);
        this.sendMessage(component);
    }

    public void sendMessage(Component component) {
        this.sendMessage(component, ChatTypes.CHAT);
    }

    public void sendMessage(Component component, ChatType type) {
        PacketWrapper chatPacket;
        ServerVersion version;
        ServerVersion serverVersion = version = PacketEvents.getAPI().getInjector().isProxy() ? this.getClientVersion().toServerVersion() : PacketEvents.getAPI().getServerManager().getVersion();
        if (version.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            chatPacket = new WrapperPlayServerSystemChatMessage(false, component);
        } else {
            ChatMessage message = version.isNewerThanOrEquals(ServerVersion.V_1_16) ? new ChatMessage_v1_16(component, type, new UUID(0L, 0L)) : new ChatMessageLegacy(component, type);
            chatPacket = new WrapperPlayServerChatMessage(message);
        }
        PacketEvents.getAPI().getProtocolManager().sendPacket(this.channel, chatPacket);
    }

    public void sendTitle(String legacyTitle, String legacySubtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        Component title = AdventureSerializer.fromLegacyFormat(legacyTitle);
        Component subtitle = AdventureSerializer.fromLegacyFormat(legacySubtitle);
        this.sendTitle(title, subtitle, fadeInTicks, stayTicks, fadeOutTicks);
    }

    public void sendTitle(Component title, Component subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        PacketWrapper animation;
        ClientVersion version = PacketEvents.getAPI().getInjector().isProxy() ? this.getClientVersion() : PacketEvents.getAPI().getServerManager().getVersion().toClientVersion();
        boolean modern = version.isNewerThanOrEquals(ClientVersion.V_1_17);
        PacketWrapper setTitle = null;
        PacketWrapper setSubtitle = null;
        if (modern) {
            animation = new WrapperPlayServerSetTitleTimes(fadeInTicks, stayTicks, fadeOutTicks);
            if (title != null) {
                setTitle = new WrapperPlayServerSetTitleText(title);
            }
            if (subtitle != null) {
                setSubtitle = new WrapperPlayServerSetTitleSubtitle(subtitle);
            }
        } else {
            animation = new WrapperPlayServerTitle(WrapperPlayServerTitle.TitleAction.SET_TIMES_AND_DISPLAY, (Component)null, null, null, fadeInTicks, stayTicks, fadeOutTicks);
            if (title != null) {
                setTitle = new WrapperPlayServerTitle(WrapperPlayServerTitle.TitleAction.SET_TITLE, title, null, null, 0, 0, 0);
            }
            if (subtitle != null) {
                setSubtitle = new WrapperPlayServerTitle(WrapperPlayServerTitle.TitleAction.SET_SUBTITLE, null, subtitle, null, 0, 0, 0);
            }
        }
        this.sendPacket(animation);
        if (setTitle != null) {
            this.sendPacket(setTitle);
        }
        if (setSubtitle != null) {
            this.sendPacket(setSubtitle);
        }
    }

    public int getMinWorldHeight() {
        return this.getMinWorldHeight(null);
    }

    public int getMinWorldHeight(@Nullable ClientVersion version) {
        if (version == null) {
            version = PacketEvents.getAPI().getInjector().isProxy() ? this.getClientVersion() : PacketEvents.getAPI().getServerManager().getVersion().toClientVersion();
        }
        return this.dimensionType.getMinY(version);
    }

    public int getTotalWorldHeight() {
        return this.getTotalWorldHeight(null);
    }

    public int getTotalWorldHeight(@Nullable ClientVersion version) {
        if (version == null) {
            version = PacketEvents.getAPI().getInjector().isProxy() ? this.getClientVersion() : PacketEvents.getAPI().getServerManager().getVersion().toClientVersion();
        }
        return this.dimensionType.getHeight(version);
    }

    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    @ApiStatus.Internal
    public void setDimensionType(DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    @Deprecated
    public void setMinWorldHeight(int minWorldHeight) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setTotalWorldHeight(int totalWorldHeight) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void switchDimensionType(ServerVersion version, Dimension dimension) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setDefaultWorldHeights(ServerVersion version, Dimension dimension) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setDefaultWorldHeights(boolean extended) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setWorldNBT(NBTList<NBTCompound> worldNBT) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Dimension getDimension() {
        return Dimension.fromDimensionType(this.dimensionType, this, null);
    }

    @Deprecated
    public void setDimension(Dimension dimension) {
        this.dimensionType = dimension.asDimensionType(this, null);
    }

    @Deprecated
    @Nullable
    public NBTCompound getWorldNBT(String worldName) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @Nullable
    public NBTCompound getWorldNBT(int worldId) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @Nullable
    public NBTCompound getWorldNBT(Dimension dimension) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @Nullable
    public String getWorldName(int worldId) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String getWorldName(Dimension dimension) {
        throw new UnsupportedOperationException();
    }
}

