/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.lib.com.github.retrooper.packetevents.protocol.potion;

import com.jtprince.lib.com.github.retrooper.packetevents.PacketEvents;
import com.jtprince.lib.com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.potion.PotionType;
import com.jtprince.lib.com.github.retrooper.packetevents.resources.ResourceLocation;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.MappingHelper;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.TypesBuilder;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import com.jtprince.lib.org.jetbrains.annotations.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PotionTypes {
    private static final Map<String, PotionType> POTION_TYPE_MAP = new HashMap<String, PotionType>();
    private static final Map<Byte, Map<Integer, PotionType>> POTION_TYPE_ID_MAP = new HashMap<Byte, Map<Integer, PotionType>>();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("entity/entity_effect_mappings");
    public static final PotionType SPEED = PotionTypes.define("speed");
    public static final PotionType SLOWNESS = PotionTypes.define("slowness");
    public static final PotionType HASTE = PotionTypes.define("haste");
    public static final PotionType MINING_FATIGUE = PotionTypes.define("mining_fatigue");
    public static final PotionType STRENGTH = PotionTypes.define("strength");
    public static final PotionType INSTANT_HEALTH = PotionTypes.define("instant_health");
    public static final PotionType INSTANT_DAMAGE = PotionTypes.define("instant_damage");
    public static final PotionType JUMP_BOOST = PotionTypes.define("jump_boost");
    public static final PotionType NAUSEA = PotionTypes.define("nausea");
    public static final PotionType REGENERATION = PotionTypes.define("regeneration");
    public static final PotionType RESISTANCE = PotionTypes.define("resistance");
    public static final PotionType FIRE_RESISTANCE = PotionTypes.define("fire_resistance");
    public static final PotionType WATER_BREATHING = PotionTypes.define("water_breathing");
    public static final PotionType INVISIBILITY = PotionTypes.define("invisibility");
    public static final PotionType BLINDNESS = PotionTypes.define("blindness");
    public static final PotionType NIGHT_VISION = PotionTypes.define("night_vision");
    public static final PotionType HUNGER = PotionTypes.define("hunger");
    public static final PotionType WEAKNESS = PotionTypes.define("weakness");
    public static final PotionType POISON = PotionTypes.define("poison");
    public static final PotionType WITHER = PotionTypes.define("wither");
    public static final PotionType HEALTH_BOOST = PotionTypes.define("health_boost");
    public static final PotionType ABSORPTION = PotionTypes.define("absorption");
    public static final PotionType SATURATION = PotionTypes.define("saturation");
    public static final PotionType GLOWING = PotionTypes.define("glowing");
    public static final PotionType LEVITATION = PotionTypes.define("levitation");
    public static final PotionType LUCK = PotionTypes.define("luck");
    public static final PotionType UNLUCK = PotionTypes.define("unluck");
    public static final PotionType SLOW_FALLING = PotionTypes.define("slow_falling");
    public static final PotionType CONDUIT_POWER = PotionTypes.define("conduit_power");
    public static final PotionType DOLPHINS_GRACE = PotionTypes.define("dolphins_grace");
    public static final PotionType BAD_OMEN = PotionTypes.define("bad_omen");
    public static final PotionType HERO_OF_THE_VILLAGE = PotionTypes.define("hero_of_the_village");
    public static final PotionType DARKNESS = PotionTypes.define("darkness");
    public static final PotionType TRIAL_OMEN = PotionTypes.define("trial_omen");
    public static final PotionType RAID_OMEN = PotionTypes.define("raid_omen");
    public static final PotionType WIND_CHARGED = PotionTypes.define("wind_charged");
    public static final PotionType WEAVING = PotionTypes.define("weaving");
    public static final PotionType OOZING = PotionTypes.define("oozing");
    public static final PotionType INFESTED = PotionTypes.define("infested");

    @Deprecated
    public static PotionType define(String key, int ignoredId) {
        return PotionTypes.define(key);
    }

    public static PotionType define(String key) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        PotionType potionType = new PotionType(){

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                return MappingHelper.getId(version, TYPES_BUILDER, data);
            }

            public boolean equals(Object obj) {
                if (obj instanceof PotionType) {
                    return this.getName().equals(((PotionType)obj).getName());
                }
                return false;
            }
        };
        MappingHelper.registerMapping(TYPES_BUILDER, POTION_TYPE_MAP, POTION_TYPE_ID_MAP, potionType);
        return potionType;
    }

    @Nullable
    public static PotionType getByName(String name) {
        return POTION_TYPE_MAP.get(name);
    }

    @Deprecated
    @Nullable
    public static PotionType getById(int id) {
        return PotionTypes.getById(id, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
    }

    @Nullable
    public static PotionType getById(int id, ServerVersion version) {
        return PotionTypes.getById(id, version.toClientVersion());
    }

    @Nullable
    public static PotionType getById(ClientVersion version, int id) {
        return PotionTypes.getById(id, version);
    }

    @Nullable
    public static PotionType getById(int id, ClientVersion version) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, PotionType> idMap = POTION_TYPE_ID_MAP.get((byte)index);
        return idMap.get(id);
    }

    public static Collection<PotionType> values() {
        return Collections.unmodifiableCollection(POTION_TYPE_MAP.values());
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }
}

