/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.chunk.impl.v1_16;

import com.jtprince.lib.com.github.retrooper.packetevents.PacketEvents;
import com.jtprince.lib.com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.stream.NetStreamInput;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.stream.NetStreamOutput;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.chunk.BaseChunk;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.chunk.NibbleArray3d;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.chunk.palette.DataPalette;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.chunk.palette.PaletteType;

public class Chunk_v1_9
implements BaseChunk {
    private static final int AIR = 0;
    private int blockCount;
    private final DataPalette dataPalette;
    private NibbleArray3d blockLight;
    private NibbleArray3d skyLight;

    public Chunk_v1_9(int blockCount, DataPalette dataPalette) {
        this.blockCount = blockCount;
        this.dataPalette = dataPalette;
    }

    public Chunk_v1_9(NetStreamInput in, boolean hasBlockLight, boolean hasSkyLight) {
        boolean isFourteen = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_14);
        boolean isSixteen = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_16);
        this.blockCount = isFourteen ? (int)in.readShort() : Integer.MAX_VALUE;
        this.dataPalette = isSixteen ? DataPalette.read(in, PaletteType.CHUNK, false) : DataPalette.readLegacy(in);
        this.blockLight = hasBlockLight ? new NibbleArray3d(in, 2048) : null;
        this.skyLight = hasSkyLight ? new NibbleArray3d(in, 2048) : null;
    }

    public static void write(NetStreamOutput out, Chunk_v1_9 chunk) {
        boolean isFourteen = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_14);
        if (isFourteen) {
            out.writeShort(chunk.blockCount);
        }
        DataPalette.write(out, chunk.dataPalette);
        if (chunk.blockLight != null) {
            out.writeBytes(chunk.blockLight.getData());
        }
        if (chunk.skyLight != null) {
            out.writeBytes(chunk.skyLight.getData());
        }
    }

    @Override
    public int getBlockId(int x, int y, int z) {
        return this.dataPalette.get(x, y, z);
    }

    @Override
    public void set(int x, int y, int z, int state) {
        int curr = this.dataPalette.set(x, y, z, state);
        if (this.blockCount == Integer.MAX_VALUE) {
            return;
        }
        if (state != 0 && curr == 0) {
            ++this.blockCount;
        } else if (state == 0 && curr != 0) {
            --this.blockCount;
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.blockCount == Integer.MAX_VALUE) {
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        if (this.dataPalette.get(x, y, z) == 0) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return this.blockCount == 0;
    }

    public NibbleArray3d getSkyLight() {
        return this.skyLight;
    }

    public void setSkyLight(NibbleArray3d skyLight) {
        this.skyLight = skyLight;
    }

    public NibbleArray3d getBlockLight() {
        return this.blockLight;
    }

    public void setBlockLight(NibbleArray3d blockLight) {
        this.blockLight = blockLight;
    }
}

