/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.chunk.impl.v1_7;

import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.chunk.BaseChunk;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.chunk.ByteArray3d;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.chunk.NibbleArray3d;

public class Chunk_v1_7
implements BaseChunk {
    private final ByteArray3d blocks;
    private NibbleArray3d metadata;
    private NibbleArray3d blocklight;
    private NibbleArray3d skylight;
    private NibbleArray3d extendedBlocks;

    public Chunk_v1_7(boolean skylight, boolean extended) {
        this(new ByteArray3d(4096), new NibbleArray3d(4096), new NibbleArray3d(4096), skylight ? new NibbleArray3d(4096) : null, extended ? new NibbleArray3d(4096) : null);
    }

    public Chunk_v1_7(ByteArray3d blocks, NibbleArray3d metadata, NibbleArray3d blocklight, NibbleArray3d skylight, NibbleArray3d extendedBlocks) {
        this.blocks = blocks;
        this.metadata = metadata;
        this.blocklight = blocklight;
        this.skylight = skylight;
        this.extendedBlocks = extendedBlocks;
    }

    @Override
    public int getBlockId(int x, int y, int z) {
        return this.blocks.get(x, y, z) | this.extendedBlocks.get(x, y, z) << 12;
    }

    @Override
    public void set(int x, int y, int z, int combinedID) {
        this.blocks.set(x, y, z, combinedID & 0xFF);
        this.extendedBlocks.set(x, y, z, combinedID >> 12);
    }

    @Override
    public boolean isEmpty() {
        for (byte block : this.blocks.getData()) {
            if (block == 0) continue;
            return false;
        }
        return true;
    }

    public ByteArray3d getBlocks() {
        return this.blocks;
    }

    public NibbleArray3d getMetadata() {
        return this.metadata;
    }

    public NibbleArray3d getBlockLight() {
        return this.blocklight;
    }

    public NibbleArray3d getSkyLight() {
        return this.skylight;
    }

    public NibbleArray3d getExtendedBlocks() {
        return this.extendedBlocks;
    }
}

