/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.lib.com.github.retrooper.packetevents.util;

import com.jtprince.lib.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.event.PacketSendEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.event.simple.PacketConfigReceiveEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.event.simple.PacketConfigSendEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.event.simple.PacketHandshakeReceiveEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.event.simple.PacketHandshakeSendEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.event.simple.PacketLoginReceiveEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.event.simple.PacketLoginSendEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.event.simple.PacketPlayReceiveEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.event.simple.PacketPlaySendEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.event.simple.PacketStatusReceiveEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.event.simple.PacketStatusSendEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.exception.PacketProcessException;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.User;

public class EventCreationUtil {
    public static PacketReceiveEvent createReceiveEvent(Object channel, User user, Object player, Object buffer, boolean autoProtocolTranslation) throws PacketProcessException {
        switch (user.getDecoderState()) {
            case HANDSHAKING: {
                return new PacketHandshakeReceiveEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
            case STATUS: {
                return new PacketStatusReceiveEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
            case LOGIN: {
                return new PacketLoginReceiveEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
            case PLAY: {
                return new PacketPlayReceiveEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
            case CONFIGURATION: {
                return new PacketConfigReceiveEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
        }
        throw new RuntimeException("Unknown connection state " + (Object)((Object)user.getDecoderState()) + "!");
    }

    public static PacketSendEvent createSendEvent(Object channel, User user, Object player, Object buffer, boolean autoProtocolTranslation) throws PacketProcessException {
        switch (user.getEncoderState()) {
            case HANDSHAKING: {
                return new PacketHandshakeSendEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
            case STATUS: {
                return new PacketStatusSendEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
            case LOGIN: {
                return new PacketLoginSendEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
            case PLAY: {
                return new PacketPlaySendEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
            case CONFIGURATION: {
                return new PacketConfigSendEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
        }
        throw new RuntimeException("Unknown connection state " + (Object)((Object)user.getEncoderState()) + "!");
    }
}

