/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.lib.com.github.retrooper.packetevents.util.mappings;

import com.jtprince.lib.com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.nbt.NBTNumber;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.nbt.NBTString;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.nbt.NBTType;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.nbt.serializer.SequentialNBTReader;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.jtprince.lib.com.github.retrooper.packetevents.resources.ResourceLocation;
import com.jtprince.lib.com.github.retrooper.packetevents.util.VersionMapper;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.ListDiff;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.MapDiff;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.MappingHelper;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.VersionedRegistry;
import com.jtprince.lib.org.jetbrains.annotations.ApiStatus;
import com.jtprince.lib.org.jetbrains.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class TypesBuilder {
    private final String mapPath;
    private Map<ClientVersion, Map<String, Integer>> entries = new HashMap<ClientVersion, Map<String, Integer>>();
    private VersionMapper versionMapper;
    @Nullable
    VersionedRegistry<?> registry;

    public TypesBuilder(String mapPath, boolean lazy) {
        this.mapPath = mapPath;
        if (!lazy) {
            this.load();
        }
    }

    public TypesBuilder(String mapPath) {
        this(mapPath, false);
    }

    public void load() {
        try (SequentialNBTReader.Compound compound = MappingHelper.decompress("mappings/" + this.mapPath);){
            compound.skipOne();
            int length = ((NBTNumber)compound.next().getValue()).getAsInt();
            SequentialNBTReader.Compound entries = (SequentialNBTReader.Compound)compound.next().getValue();
            ClientVersion[] versions = new ClientVersion[length];
            Object first = entries.next();
            if (((NBT)first.getValue()).getType() == NBTType.LIST) {
                this.loadAsArray((Map.Entry<String, NBT>)first, entries, versions);
            } else {
                this.loadAsMap((Map.Entry<String, NBT>)first, entries, versions);
            }
            this.versionMapper = new VersionMapper(versions);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load mapping files.", e);
        }
    }

    private void loadAsArray(Map.Entry<String, NBT> first, SequentialNBTReader.Compound entries, ClientVersion[] versions) {
        ClientVersion start;
        versions[0] = start = ClientVersion.valueOf(first.getKey());
        ArrayList<String> lastEntries = new ArrayList<String>();
        for (NBT entry : (SequentialNBTReader.List)first.getValue()) {
            lastEntries.add(((NBTString)entry).getValue());
        }
        Consumer<ClientVersion> mapLoader = version -> {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int i = 0; i < lastEntries.size(); ++i) {
                map.put((String)lastEntries.get(i), i);
            }
            this.entries.put((ClientVersion)((Object)version), (Map<String, Integer>)map);
        };
        mapLoader.accept(start);
        int i = 1;
        for (Map.Entry<String, NBT> entry : entries) {
            ClientVersion version2 = ClientVersion.valueOf(entry.getKey());
            versions[i++] = version2;
            List<ListDiff<String>> diff = MappingHelper.createListDiff((SequentialNBTReader.Compound)entry.getValue());
            for (int j = diff.size() - 1; j >= 0; --j) {
                diff.get(j).applyTo(lastEntries);
            }
            mapLoader.accept(version2);
        }
    }

    private void loadAsMap(Map.Entry<String, NBT> first, SequentialNBTReader.Compound entries, ClientVersion[] versions) {
        ClientVersion start;
        versions[0] = start = ClientVersion.valueOf(first.getKey());
        Map<String, Integer> lastEntries = StreamSupport.stream(((SequentialNBTReader.Compound)first.getValue()).spliterator(), false).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((NBTNumber)entry.getValue()).getAsInt()));
        Consumer<ClientVersion> mapLoader = version -> {
            HashMap map = new HashMap(lastEntries);
            this.entries.put((ClientVersion)((Object)version), map);
        };
        mapLoader.accept(start);
        int i = 1;
        for (Map.Entry<String, NBT> entry2 : entries) {
            ClientVersion version2 = ClientVersion.valueOf(entry2.getKey());
            versions[i++] = version2;
            List<MapDiff<String, Integer>> diff = MappingHelper.createDiff((SequentialNBTReader.Compound)entry2.getValue());
            for (MapDiff<String, Integer> d : diff) {
                d.applyTo(lastEntries);
            }
            mapLoader.accept(version2);
        }
    }

    @ApiStatus.Internal
    @Nullable
    public VersionedRegistry<?> getRegistry() {
        return this.registry;
    }

    public ClientVersion[] getVersions() {
        return this.versionMapper.getVersions();
    }

    public ClientVersion[] getReversedVersions() {
        return this.versionMapper.getReversedVersions();
    }

    public int getDataIndex(ClientVersion rawVersion) {
        return this.versionMapper.getIndex(rawVersion);
    }

    public void unloadFileMappings() {
        this.entries.clear();
        this.entries = null;
    }

    public TypesBuilderData define(String key) {
        ResourceLocation name = new ResourceLocation(key);
        int[] ids = new int[this.getVersions().length];
        int index = 0;
        for (ClientVersion v : this.getVersions()) {
            int id;
            Map<String, Integer> map = this.entries.get((Object)v);
            ids[index] = map.containsKey(key) ? (id = map.get(key).intValue()) : -1;
            ++index;
        }
        return new TypesBuilderData(this, name, ids);
    }
}

