/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.lib.io.github.retrooper.packetevents.manager.server;

import com.jtprince.lib.com.github.retrooper.packetevents.PacketEvents;
import com.jtprince.lib.com.github.retrooper.packetevents.manager.server.ServerManager;
import com.jtprince.lib.com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.User;
import com.jtprince.lib.com.github.retrooper.packetevents.util.PEVersion;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.GlobalRegistryHolder;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ServerManagerImpl
implements ServerManager {
    private ServerVersion serverVersion;

    private ServerVersion resolveVersionNoCache() {
        PEVersion latestVersion;
        Plugin plugin = (Plugin)PacketEvents.getAPI().getPlugin();
        String bukkitVersion = Bukkit.getBukkitVersion();
        ServerVersion fallbackVersion = ServerVersion.V_1_8_8;
        if (bukkitVersion.contains("Unknown")) {
            return fallbackVersion;
        }
        PEVersion version = PEVersion.fromString(bukkitVersion.substring(0, bukkitVersion.indexOf("-")));
        if (version.isNewerThan(latestVersion = PEVersion.fromString(ServerVersion.getLatest().getReleaseName()))) {
            plugin.getLogger().warning("[packetevents] We currently do not support the minecraft version " + version + ", so things might break. PacketEvents will behave as if the minecraft version were " + latestVersion + "!");
            return ServerVersion.getLatest();
        }
        for (ServerVersion val : ServerVersion.reversedValues()) {
            if (!bukkitVersion.contains(val.getReleaseName())) continue;
            return val;
        }
        plugin.getLogger().warning("[packetevents] Your server software is preventing us from checking the server version. This is what we found: " + Bukkit.getBukkitVersion() + ". We will assume the server version is " + fallbackVersion.name() + "...");
        return fallbackVersion;
    }

    @Override
    public ServerVersion getVersion() {
        if (this.serverVersion == null) {
            this.serverVersion = this.resolveVersionNoCache();
        }
        return this.serverVersion;
    }

    @Override
    public Object getRegistryCacheKey(User user, ClientVersion version) {
        return GlobalRegistryHolder.getGlobalRegistryCacheKey(user, version);
    }
}

