/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.lib.net.kyori.adventure.text.format;

import com.jtprince.lib.net.kyori.adventure.key.Key;
import com.jtprince.lib.net.kyori.adventure.text.event.ClickEvent;
import com.jtprince.lib.net.kyori.adventure.text.event.HoverEvent;
import com.jtprince.lib.net.kyori.adventure.text.format.DecorationMap;
import com.jtprince.lib.net.kyori.adventure.text.format.TextColor;
import com.jtprince.lib.net.kyori.adventure.text.format.TextDecoration;
import com.jtprince.lib.org.jetbrains.annotations.ApiStatus;
import com.jtprince.lib.org.jetbrains.annotations.NotNull;
import com.jtprince.lib.org.jetbrains.annotations.Nullable;
import com.jtprince.lib.org.jetbrains.annotations.Unmodifiable;
import java.util.EnumMap;
import java.util.Map;

@ApiStatus.NonExtendable
public interface StyleGetter {
    @Nullable
    public Key font();

    @Nullable
    public TextColor color();

    default public boolean hasDecoration(@NotNull TextDecoration decoration) {
        return this.decoration(decoration) == TextDecoration.State.TRUE;
    }

    public @NotNull TextDecoration.State decoration(@NotNull TextDecoration var1);

    default public @Unmodifiable @NotNull Map<TextDecoration, TextDecoration.State> decorations() {
        EnumMap<TextDecoration, TextDecoration.State> decorations = new EnumMap<TextDecoration, TextDecoration.State>(TextDecoration.class);
        for (TextDecoration decoration : DecorationMap.DECORATIONS) {
            TextDecoration.State value = this.decoration(decoration);
            decorations.put(decoration, value);
        }
        return decorations;
    }

    @Nullable
    public ClickEvent clickEvent();

    @Nullable
    public HoverEvent<?> hoverEvent();

    @Nullable
    public String insertion();
}

