/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.lib.org.geysermc.hurricane;

import com.jtprince.lib.org.geysermc.hurricane.NMSReflection;
import com.jtprince.lib.org.geysermc.hurricane.ReflectionAPI;
import com.jtprince.lib.org.jetbrains.annotations.Contract;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.PointedDripstone;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;

public final class CollisionFix
implements Listener {
    private final boolean bambooEnabled;
    private final BoundingBox originalBambooBoundingBox = this.box(6.5, 0.0, 6.5, 9.5, 16.0, 9.5);
    private final boolean pointedDripstoneEnabled;
    private final BoundingBox tipMergeDripstoneBox = this.box(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    private final BoundingBox tipUpDripstoneBox = this.box(5.0, 0.0, 5.0, 11.0, 11.0, 11.0);
    private final BoundingBox tipDownDripstoneBox = this.box(5.0, 5.0, 5.0, 11.0, 16.0, 11.0);
    private final BoundingBox frustumDripstoneBox = this.box(4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
    private final BoundingBox middleDripstoneBox = this.box(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    private final BoundingBox baseDripstoneBox = this.box(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);

    public CollisionFix(Plugin plugin, boolean bambooEnabled, boolean pointedDripstoneEnabled) {
        this.bambooEnabled = bambooEnabled;
        this.pointedDripstoneEnabled = pointedDripstoneEnabled;
        if (bambooEnabled) {
            try {
                Class<?> bambooBlockClass = NMSReflection.getNMSClass("world.level.block", "BlockBamboo");
                boolean hasCodec = Arrays.stream(bambooBlockClass.getFields()).anyMatch(field -> field.getType().getSimpleName().equals("MapCodec"));
                Field bambooBoundingBox = ReflectionAPI.getFieldAccessible(bambooBlockClass, hasCodec ? "g" : (NMSReflection.mojmap ? "f" : "c"));
                CollisionFix.applyNoBoundingBox(bambooBoundingBox);
                plugin.getLogger().info("Bamboo collision hack enabled.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (pointedDripstoneEnabled) {
            try {
                Class<?> dripstoneBlockClass = NMSReflection.getMojmapNMSClass("world.level.block.PointedDripstoneBlock");
                boolean foundBoundingBoxes = false;
                int boundingBoxCount = 0;
                for (Field field2 : dripstoneBlockClass.getDeclaredFields()) {
                    if (boundingBoxCount >= 6) break;
                    if (Modifier.isStatic(field2.getModifiers()) && field2.getType().getSimpleName().equals("VoxelShape")) {
                        foundBoundingBoxes = true;
                        ++boundingBoxCount;
                        CollisionFix.applyNoBoundingBox(field2);
                        continue;
                    }
                    if (foundBoundingBoxes) break;
                }
                plugin.getLogger().info("Dripstone collision hack enabled.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Block placed = event.getBlockPlaced();
        Material material = placed.getType();
        if (this.bambooEnabled && material.equals((Object)Material.BAMBOO)) {
            this.testIfCanBuild(event, this.originalBambooBoundingBox);
        } else if (this.pointedDripstoneEnabled && material.equals((Object)Material.POINTED_DRIPSTONE)) {
            PointedDripstone data = (PointedDripstone)placed.getBlockData();
            this.testIfCanBuild(event, switch (data.getThickness()) {
                case PointedDripstone.Thickness.TIP -> data.getVerticalDirection() == BlockFace.DOWN ? this.tipDownDripstoneBox : this.tipUpDripstoneBox;
                case PointedDripstone.Thickness.TIP_MERGE -> this.tipMergeDripstoneBox;
                case PointedDripstone.Thickness.FRUSTUM -> this.frustumDripstoneBox;
                case PointedDripstone.Thickness.MIDDLE -> this.middleDripstoneBox;
                default -> this.baseDripstoneBox;
            });
        }
    }

    private void testIfCanBuild(BlockPlaceEvent event, BoundingBox box) {
        BoundingBox currentBoundingBox = box.clone().shift(event.getBlockPlaced().getLocation());
        if (event.getPlayer().getBoundingBox().overlaps(currentBoundingBox)) {
            event.setBuild(false);
        }
    }

    @Contract(value="_, _, _, _, _, _-> new")
    private BoundingBox box(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return new BoundingBox(minX / 16.0, minY / 16.0, minZ / 16.0, maxX / 16.0, maxY / 16.0, maxZ / 16.0);
    }

    private static void applyNoBoundingBox(Field field) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        double x1 = 0.0;
        double y1 = 0.0;
        double z1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double z2 = 0.0;
        if (field.getType().getSimpleName().equals("AxisAlignedBB")) {
            Class<?> boundingBoxClass = field.getType();
            Constructor<?> boundingBoxConstructor = boundingBoxClass.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
            Object boundingBox = boundingBoxConstructor.newInstance(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            ReflectionAPI.setFinalValue(field, boundingBox);
        } else if (field.getType().getSimpleName().equals("VoxelShape")) {
            Method createVoxelShape;
            try {
                createVoxelShape = ReflectionAPI.getMethod(NMSReflection.getNMSClass("world.phys.shapes", "VoxelShapes"), "b", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
            }
            catch (NoSuchMethodException e) {
                createVoxelShape = ReflectionAPI.getMethod(NMSReflection.getNMSClass("world.phys.shapes", "VoxelShapes"), "create", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
            }
            Object boundingBox = ReflectionAPI.invokeMethod(createVoxelShape, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            ReflectionAPI.setFinalValue(field, boundingBox);
        } else {
            throw new IllegalStateException();
        }
    }
}

