/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class PartialStacktraceLogger {
    public static void logStacktrace(Logger logger, String message, Exception e) {
        ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>(Arrays.asList(e.getStackTrace()));
        ArrayList<StackTraceElement> current = new ArrayList<StackTraceElement>(Arrays.asList(Thread.currentThread().getStackTrace()));
        int popBuffer = 2;
        int popped = 0;
        while (stack.size() > 3 && current.size() > 3 && ((StackTraceElement)stack.get(stack.size() - 2)).equals(current.get(current.size() - 2))) {
            stack.remove(stack.size() - 1);
            current.remove(current.size() - 1);
            ++popped;
        }
        logger.severe(message + "\nCaused by " + e.getClass().getName() + ": " + e.getMessage() + "\n  " + stack.stream().map(StackTraceElement::toString).collect(Collectors.joining("\n  ")) + "\n (+" + popped + " hidden frames)");
    }
}

