/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.block;

import eu.pintergabor.fluidpipes.block.BaseFitting;
import eu.pintergabor.fluidpipes.block.BasePipe;
import eu.pintergabor.fluidpipes.block.util.TickUtil;
import eu.pintergabor.fluidpipes.registry.ModStats;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract sealed class BaseBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock
permits BaseFitting, BasePipe {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public final int tickRate;
    public static final Direction[] DIRECTIONS = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN};

    protected BaseBlock(BlockBehaviour.Properties props, int tickRate) {
        super(props);
        this.tickRate = tickRate;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack itemStack) {
        super.setPlacedBy(level, pos, state, placer, itemStack);
        if (!level.isClientSide && placer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)placer;
            serverPlayer.awardStat((ResourceLocation)ModStats.INTERACTIONS.get());
        }
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            BlockPos pos = context.getClickedPos();
            Level level = context.getLevel();
            return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).is((Fluid)Fluids.WATER)));
        }
        return null;
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState blockState, @NotNull LevelReader level, @NotNull ScheduledTickAccess scheduledTickAccess, @NotNull BlockPos pos, @NotNull Direction direction, @NotNull BlockPos neighborPos, @NotNull BlockState neighborState, @NotNull RandomSource random) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return blockState;
    }

    protected boolean propagatesSkylightDown(@NotNull BlockState blockState) {
        return true;
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType pathComputationType) {
        return false;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    @NotNull
    public FluidState getFluidState(@NotNull BlockState blockState) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(blockState);
    }

    public int getTickRate() {
        return this.tickRate;
    }

    public static TickUtil.TickPos getTickPos(Level level, BlockState state) {
        BaseBlock block = (BaseBlock)state.getBlock();
        int rate = block.getTickRate();
        return TickUtil.getTickPos(level, rate);
    }
}

