/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.block;

import eu.pintergabor.fluidpipes.block.BaseBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract non-sealed class BaseFitting
extends BaseBlock {
    private static final VoxelShape FITTING_SHAPE = Block.box((double)2.5, (double)2.5, (double)2.5, (double)13.5, (double)13.5, (double)13.5);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    protected BaseFitting(BlockBehaviour.Properties props, int tickRate) {
        super(props, tickRate);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return FITTING_SHAPE;
    }

    @NotNull
    public VoxelShape getInteractionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return FITTING_SHAPE;
    }

    public static boolean isReceivingRedstonePower(@NotNull Level level, @NotNull BlockPos blockPos) {
        for (Direction d : DIRECTIONS) {
            BlockPos neighbourPos = blockPos.relative(d);
            if (0 >= level.getSignal(neighbourPos, d)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            BlockPos pos = context.getClickedPos();
            Level level = context.getLevel();
            return (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(BaseFitting.isReceivingRedstonePower(level, pos)));
        }
        return null;
    }

    protected void neighborChanged(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        boolean powered = BaseFitting.isReceivingRedstonePower(level, pos);
        if (powered != (Boolean)state.getValue((Property)POWERED)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)));
        }
    }
}

