/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.block;

import eu.pintergabor.fluidpipes.block.BaseBlock;
import eu.pintergabor.fluidpipes.block.BaseFitting;
import eu.pintergabor.fluidpipes.registry.ModSoundEvents;
import eu.pintergabor.fluidpipes.registry.ModStats;
import eu.pintergabor.fluidpipes.registry.util.ModProperties;
import eu.pintergabor.fluidpipes.tag.ModItemTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract non-sealed class BasePipe
extends BaseBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    public static final BooleanProperty FRONT_CONNECTED = ModProperties.FRONT_CONNECTED;
    public static final BooleanProperty BACK_CONNECTED = ModProperties.BACK_CONNECTED;
    public static final BooleanProperty SMOOTH = ModProperties.SMOOTH;
    private static final VoxelShape UP_SHAPE = Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), (VoxelShape)Block.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
    private static final VoxelShape DOWN_SHAPE = Shapes.or((VoxelShape)Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0));
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)Block.box((double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0, (double)16.0), (VoxelShape)Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)2.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)14.0), (VoxelShape)Block.box((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0));
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0), (VoxelShape)Block.box((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)Block.box((double)2.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), (VoxelShape)Block.box((double)0.0, (double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)13.0));
    private static final VoxelShape DOWN_FRONT = Shapes.or((VoxelShape)Block.box((double)4.0, (double)-2.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (VoxelShape)Block.box((double)3.0, (double)-4.0, (double)3.0, (double)13.0, (double)-2.0, (double)13.0));
    private static final VoxelShape EAST_FRONT = Shapes.or((VoxelShape)Block.box((double)0.0, (double)4.0, (double)4.0, (double)18.0, (double)12.0, (double)12.0), (VoxelShape)Block.box((double)18.0, (double)3.0, (double)3.0, (double)20.0, (double)13.0, (double)13.0));
    private static final VoxelShape NORTH_FRONT = Shapes.or((VoxelShape)Block.box((double)4.0, (double)4.0, (double)-2.0, (double)12.0, (double)12.0, (double)16.0), (VoxelShape)Block.box((double)3.0, (double)3.0, (double)-4.0, (double)13.0, (double)13.0, (double)-2.0));
    private static final VoxelShape SOUTH_FRONT = Shapes.or((VoxelShape)Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)18.0), (VoxelShape)Block.box((double)3.0, (double)3.0, (double)18.0, (double)13.0, (double)13.0, (double)20.0));
    private static final VoxelShape WEST_FRONT = Shapes.or((VoxelShape)Block.box((double)-2.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), (VoxelShape)Block.box((double)-4.0, (double)3.0, (double)3.0, (double)-2.0, (double)13.0, (double)13.0));
    private static final VoxelShape UP_FRONT = Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)18.0, (double)12.0), (VoxelShape)Block.box((double)3.0, (double)18.0, (double)3.0, (double)13.0, (double)20.0, (double)13.0));
    private static final VoxelShape DOWN_BACK = Shapes.or((VoxelShape)Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)20.0, (double)12.0), (VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0));
    private static final VoxelShape EAST_BACK = Shapes.or((VoxelShape)Block.box((double)-4.0, (double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0), (VoxelShape)Block.box((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
    private static final VoxelShape NORTH_BACK = Shapes.or((VoxelShape)Block.box((double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0, (double)20.0), (VoxelShape)Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)2.0));
    private static final VoxelShape SOUTH_BACK = Shapes.or((VoxelShape)Block.box((double)4.0, (double)4.0, (double)-4.0, (double)12.0, (double)12.0, (double)14.0), (VoxelShape)Block.box((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0));
    private static final VoxelShape WEST_BACK = Shapes.or((VoxelShape)Block.box((double)2.0, (double)4.0, (double)4.0, (double)20.0, (double)12.0, (double)12.0), (VoxelShape)Block.box((double)0.0, (double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)13.0));
    private static final VoxelShape UP_BACK = Shapes.or((VoxelShape)Block.box((double)4.0, (double)-4.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), (VoxelShape)Block.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
    private static final VoxelShape DOWN_DOUBLE = Block.box((double)4.0, (double)-4.0, (double)4.0, (double)12.0, (double)20.0, (double)12.0);
    private static final VoxelShape NORTH_DOUBLE = Block.box((double)4.0, (double)4.0, (double)-4.0, (double)12.0, (double)12.0, (double)20.0);
    private static final VoxelShape EAST_DOUBLE = Block.box((double)-4.0, (double)4.0, (double)4.0, (double)20.0, (double)12.0, (double)12.0);
    private static final VoxelShape DOWN_SMOOTH = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape NORTH_SMOOTH = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape EAST_SMOOTH = Block.box((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape DOWN_BACK_SMOOTH = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)20.0, (double)12.0);
    private static final VoxelShape NORTH_BACK_SMOOTH = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)20.0);
    private static final VoxelShape SOUTH_BACK_SMOOTH = Block.box((double)4.0, (double)4.0, (double)-4.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape EAST_BACK_SMOOTH = Block.box((double)-4.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape WEST_BACK_SMOOTH = Block.box((double)0.0, (double)4.0, (double)4.0, (double)20.0, (double)12.0, (double)12.0);
    private static final VoxelShape UP_BACK_SMOOTH = Block.box((double)4.0, (double)-4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    protected BasePipe(BlockBehaviour.Properties props, int tickRate) {
        super(props, tickRate);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.DOWN)).setValue((Property)SMOOTH, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, FRONT_CONNECTED, BACK_CONNECTED, SMOOTH});
    }

    public VoxelShape getPipeShape(BlockState state) {
        boolean front = (Boolean)state.getValue((Property)FRONT_CONNECTED);
        boolean back = (Boolean)state.getValue((Property)BACK_CONNECTED);
        boolean smooth = (Boolean)state.getValue((Property)SMOOTH);
        if (smooth && back) {
            return switch ((Direction)state.getValue(FACING)) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN -> DOWN_BACK_SMOOTH;
                case Direction.UP -> UP_BACK_SMOOTH;
                case Direction.NORTH -> NORTH_BACK_SMOOTH;
                case Direction.SOUTH -> SOUTH_BACK_SMOOTH;
                case Direction.EAST -> EAST_BACK_SMOOTH;
                case Direction.WEST -> WEST_BACK_SMOOTH;
            };
        }
        if (smooth) {
            return switch ((Direction)state.getValue(FACING)) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN, Direction.UP -> DOWN_SMOOTH;
                case Direction.NORTH, Direction.SOUTH -> NORTH_SMOOTH;
                case Direction.EAST, Direction.WEST -> EAST_SMOOTH;
            };
        }
        if (front && back) {
            return switch ((Direction)state.getValue(FACING)) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN, Direction.UP -> DOWN_DOUBLE;
                case Direction.NORTH, Direction.SOUTH -> NORTH_DOUBLE;
                case Direction.EAST, Direction.WEST -> EAST_DOUBLE;
            };
        }
        if (front) {
            return switch ((Direction)state.getValue(FACING)) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN -> DOWN_FRONT;
                case Direction.UP -> UP_FRONT;
                case Direction.NORTH -> NORTH_FRONT;
                case Direction.SOUTH -> SOUTH_FRONT;
                case Direction.EAST -> EAST_FRONT;
                case Direction.WEST -> WEST_FRONT;
            };
        }
        if (back) {
            return switch ((Direction)state.getValue(FACING)) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN -> DOWN_BACK;
                case Direction.UP -> UP_BACK;
                case Direction.NORTH -> NORTH_BACK;
                case Direction.SOUTH -> SOUTH_BACK;
                case Direction.EAST -> EAST_BACK;
                case Direction.WEST -> WEST_BACK;
            };
        }
        return switch ((Direction)state.getValue(FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> DOWN_SHAPE;
            case Direction.UP -> UP_SHAPE;
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
        };
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getPipeShape(state);
    }

    @NotNull
    public VoxelShape getInteractionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return this.getPipeShape(state);
    }

    private static boolean needExtension(@NotNull BlockState otherBlockState, @NotNull Direction direction) {
        Block otherBlock = otherBlockState.getBlock();
        if (otherBlock instanceof BasePipe) {
            Direction facing = (Direction)otherBlockState.getValue(FACING);
            return facing != direction.getOpposite() && facing != direction;
        }
        return otherBlock instanceof BaseFitting;
    }

    public static boolean needFrontExtension(@NotNull LevelReader level, @NotNull BlockPos blockPos, @NotNull Direction facing) {
        BlockState state = level.getBlockState(blockPos.relative(facing));
        return BasePipe.needExtension(state, facing);
    }

    public static boolean needBackExtension(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Direction facing) {
        Direction opposite = facing.getOpposite();
        BlockPos backPos = pos.relative(opposite);
        BlockState backState = level.getBlockState(backPos);
        return BasePipe.needExtension(backState, facing);
    }

    public static boolean isSmooth(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Direction facing) {
        BlockPos frontPos = pos.relative(facing);
        BlockState frontState = level.getBlockState(frontPos);
        Block frontBlock = frontState.getBlock();
        if (frontBlock instanceof BasePipe) {
            Direction frontFacing = (Direction)frontState.getValue(FACING);
            return frontFacing == facing && !BasePipe.needExtension(frontState, facing);
        }
        return false;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            Level level = context.getLevel();
            Direction facing = context.getClickedFace();
            BlockPos pos = context.getClickedPos();
            return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(FACING, (Comparable)facing)).setValue((Property)FRONT_CONNECTED, (Comparable)Boolean.valueOf(BasePipe.needFrontExtension((LevelReader)level, pos, facing)))).setValue((Property)BACK_CONNECTED, (Comparable)Boolean.valueOf(BasePipe.needBackExtension((LevelReader)level, pos, facing)))).setValue((Property)SMOOTH, (Comparable)Boolean.valueOf(BasePipe.isSmooth((LevelReader)level, pos, facing)));
        }
        return null;
    }

    @Override
    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull LevelReader level, @NotNull ScheduledTickAccess tickView, @NotNull BlockPos pos, @NotNull Direction direction, @NotNull BlockPos neighborPos, @NotNull BlockState neighborState, @NotNull RandomSource random) {
        BlockState superState = super.updateShape(state, level, tickView, pos, direction, neighborPos, neighborState, random);
        Direction facing = (Direction)superState.getValue(FACING);
        return (BlockState)((BlockState)((BlockState)superState.setValue((Property)FRONT_CONNECTED, (Comparable)Boolean.valueOf(BasePipe.needFrontExtension(level, pos, facing)))).setValue((Property)BACK_CONNECTED, (Comparable)Boolean.valueOf(BasePipe.needBackExtension(level, pos, facing)))).setValue((Property)SMOOTH, (Comparable)Boolean.valueOf(BasePipe.isSmooth(level, pos, facing)));
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected BlockState beforeTurning(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return state;
    }

    private void turnWithTool(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit, @NotNull ItemStack stack) {
        Direction blockFacing;
        Direction playerFacing;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
            serverPlayer.awardStat((ResourceLocation)ModStats.INTERACTIONS.get());
        }
        if ((playerFacing = hit.getDirection()) != (blockFacing = (Direction)state.getValue((Property)BlockStateProperties.FACING))) {
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)((BlockState)this.beforeTurning(level, pos, state).setValue(FACING, (Comparable)playerFacing)).setValue((Property)BACK_CONNECTED, (Comparable)Boolean.valueOf(BasePipe.needBackExtension((LevelReader)level, pos, playerFacing)))).setValue((Property)FRONT_CONNECTED, (Comparable)Boolean.valueOf(BasePipe.needFrontExtension((LevelReader)level, pos, playerFacing)))).setValue((Property)SMOOTH, (Comparable)Boolean.valueOf(BasePipe.isSmooth((LevelReader)level, pos, playerFacing))));
            ModSoundEvents.playTurnSound(level, pos);
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        }
    }

    @NotNull
    protected InteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (stack.is(ModItemTags.PIPES_AND_FITTINGS)) {
            return InteractionResult.PASS;
        }
        if (stack.is(ItemTags.HOES)) {
            this.turnWithTool(world, pos, state, player, hand, hit, stack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }
}

