/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pintergabor.fluidpipes.block.BaseFitting;
import eu.pintergabor.fluidpipes.block.FluidCarryBlock;
import eu.pintergabor.fluidpipes.block.entity.FluidFittingEntity;
import eu.pintergabor.fluidpipes.block.properties.PipeFluid;
import eu.pintergabor.fluidpipes.block.settings.FluidBlockSettings;
import eu.pintergabor.fluidpipes.block.util.DripShowUtil;
import eu.pintergabor.fluidpipes.registry.ModBlockEntities;
import eu.pintergabor.fluidpipes.registry.util.ModProperties;
import eu.pintergabor.fluidpipes.tag.ModItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public non-sealed class FluidFitting
extends BaseFitting
implements FluidCarryBlock {
    public static final EnumProperty<PipeFluid> FLUID = ModProperties.FLUID;
    public final float cloggingProbability;
    public final boolean canCarryWater;
    public final boolean canCarryLava;
    public final float fireBreakProbability;
    public final float fireDripProbability;
    public final float wateringProbability;
    public final float waterDrippingProbability;
    public final float lavaDrippingProbability;
    public final float waterFillingProbability;
    public final float lavaFillingProbability;
    public static final MapCodec<FluidFitting> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidFitting.propertiesCodec(), (App)Codec.INT.fieldOf("tick_rate").forGetter(fitting -> fitting.tickRate), (App)Codec.BOOL.fieldOf("can_carry_water").forGetter(fitting -> fitting.canCarryWater), (App)Codec.BOOL.fieldOf("can_carry_lava").forGetter(fitting -> fitting.canCarryLava), (App)Codec.FLOAT.fieldOf("clogging_probability").forGetter(fitting -> Float.valueOf(fitting.cloggingProbability)), (App)Codec.FLOAT.fieldOf("fire_break_probability").forGetter(fitting -> Float.valueOf(fitting.fireBreakProbability)), (App)Codec.FLOAT.fieldOf("fire_drip_probability").forGetter(fitting -> Float.valueOf(fitting.fireDripProbability)), (App)Codec.FLOAT.fieldOf("watering_probability").forGetter(fitting -> Float.valueOf(fitting.wateringProbability)), (App)Codec.FLOAT.fieldOf("water_dripping_probability").forGetter(fitting -> Float.valueOf(fitting.waterDrippingProbability)), (App)Codec.FLOAT.fieldOf("lava_dripping_probability").forGetter(fitting -> Float.valueOf(fitting.lavaDrippingProbability)), (App)Codec.FLOAT.fieldOf("water_filling_probability").forGetter(fitting -> Float.valueOf(fitting.waterFillingProbability)), (App)Codec.FLOAT.fieldOf("lava_filling_probability").forGetter(fitting -> Float.valueOf(fitting.lavaFillingProbability))).apply((Applicative)instance, FluidFitting::new));

    public FluidFitting(BlockBehaviour.Properties props, int tickRate, boolean canCarryWater, boolean canCarryLava, float cloggingProbability, float fireBreakProbability, float fireDripProbability, float wateringProbability, float waterDrippingProbability, float lavaDrippingProbability, float waterFillingProbability, float lavaFillingProbability) {
        super(props, tickRate);
        this.canCarryWater = canCarryWater;
        this.canCarryLava = canCarryLava;
        this.cloggingProbability = cloggingProbability;
        this.fireBreakProbability = fireBreakProbability;
        this.fireDripProbability = fireDripProbability;
        this.wateringProbability = wateringProbability;
        this.waterDrippingProbability = waterDrippingProbability;
        this.lavaDrippingProbability = lavaDrippingProbability;
        this.waterFillingProbability = waterFillingProbability;
        this.lavaFillingProbability = lavaFillingProbability;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(FLUID, (Comparable)((Object)PipeFluid.NONE)));
    }

    public FluidFitting(BlockBehaviour.Properties props, FluidBlockSettings modSettings) {
        this(props, modSettings.tickRate(), modSettings.canCarryWater(), modSettings.canCarryLava(), modSettings.cloggingProbability(), modSettings.fireBreakProbability(), modSettings.fireDripProbability(), modSettings.wateringProbability(), modSettings.waterDrippingProbability(), modSettings.lavaDrippingProbability(), modSettings.waterFillingProbability(), modSettings.lavaFillingProbability());
    }

    @Override
    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FLUID});
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new FluidFittingEntity(pos, state);
    }

    @NotNull
    protected InteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (stack.is(ModItemTags.PIPES_AND_FITTINGS)) {
            return InteractionResult.PASS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.animateTick(state, level, pos, random);
        DripShowUtil.showDrip(level, pos, state, 0.0);
    }

    protected void affectNeighborsAfterRemoval(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, boolean moved) {
        level.removeBlockEntity(pos);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        if (!level.isClientSide) {
            return FluidFitting.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.FLUID_FITTING_ENTITY.get()), FluidFittingEntity::serverTick);
        }
        return null;
    }

    @Override
    public boolean canCarryWater() {
        return this.canCarryWater;
    }

    @Override
    public boolean canCarryLava() {
        return this.canCarryLava;
    }

    @Override
    public float getCloggingProbability() {
        return this.cloggingProbability;
    }

    @Override
    public float getFireBreakProbability() {
        return this.fireBreakProbability;
    }

    @Override
    public float getWaterDrippingProbability() {
        return this.waterDrippingProbability;
    }

    @Override
    public float getLavaDrippingProbability() {
        return this.lavaDrippingProbability;
    }

    @Override
    public float getWaterFillingProbability() {
        return this.waterFillingProbability;
    }

    @Override
    public float getLavaFillingProbability() {
        return this.lavaFillingProbability;
    }

    @NotNull
    protected MapCodec<? extends FluidFitting> codec() {
        return CODEC;
    }
}

