/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pintergabor.fluidpipes.block.BasePipe;
import eu.pintergabor.fluidpipes.block.FluidCarryBlock;
import eu.pintergabor.fluidpipes.block.entity.FluidPipeEntity;
import eu.pintergabor.fluidpipes.block.properties.PipeFluid;
import eu.pintergabor.fluidpipes.block.settings.FluidBlockSettings;
import eu.pintergabor.fluidpipes.block.util.DripShowUtil;
import eu.pintergabor.fluidpipes.block.util.FluidDispenseUtil;
import eu.pintergabor.fluidpipes.registry.ModBlockEntities;
import eu.pintergabor.fluidpipes.registry.util.ModProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public non-sealed class FluidPipe
extends BasePipe
implements FluidCarryBlock {
    public static final EnumProperty<PipeFluid> FLUID = ModProperties.FLUID;
    public static final BooleanProperty OUTFLOW = ModProperties.OUTFLOW;
    public final float cloggingProbability;
    public final boolean canCarryWater;
    public final boolean canCarryLava;
    public final float fireBreakProbability;
    public final float fireDripProbability;
    public final float wateringProbability;
    public final float waterDrippingProbability;
    public final float lavaDrippingProbability;
    public final float waterFillingProbability;
    public final float lavaFillingProbability;
    public static final MapCodec<FluidPipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidPipe.propertiesCodec(), (App)Codec.INT.fieldOf("tick_rate").forGetter(fitting -> fitting.tickRate), (App)Codec.BOOL.fieldOf("can_carry_water").forGetter(fitting -> fitting.canCarryWater), (App)Codec.BOOL.fieldOf("can_carry_lava").forGetter(fitting -> fitting.canCarryLava), (App)Codec.FLOAT.fieldOf("clogging_probability").forGetter(fitting -> Float.valueOf(fitting.cloggingProbability)), (App)Codec.FLOAT.fieldOf("fire_break_probability").forGetter(fitting -> Float.valueOf(fitting.fireBreakProbability)), (App)Codec.FLOAT.fieldOf("fire_drip_probability").forGetter(fitting -> Float.valueOf(fitting.fireDripProbability)), (App)Codec.FLOAT.fieldOf("watering_probability").forGetter(fitting -> Float.valueOf(fitting.wateringProbability)), (App)Codec.FLOAT.fieldOf("water_dripping_probability").forGetter(fitting -> Float.valueOf(fitting.waterDrippingProbability)), (App)Codec.FLOAT.fieldOf("lava_dripping_probability").forGetter(fitting -> Float.valueOf(fitting.lavaDrippingProbability)), (App)Codec.FLOAT.fieldOf("water_filling_probability").forGetter(fitting -> Float.valueOf(fitting.waterFillingProbability)), (App)Codec.FLOAT.fieldOf("lava_filling_probability").forGetter(fitting -> Float.valueOf(fitting.lavaFillingProbability))).apply((Applicative)instance, FluidPipe::new));

    public FluidPipe(BlockBehaviour.Properties props, int tickRate, boolean canCarryWater, boolean canCarryLava, float cloggingProbability, float fireBreakProbability, float fireDripProbability, float wateringProbability, float waterDrippingProbability, float lavaDrippingProbability, float waterFillingProbability, float lavaFillingProbability) {
        super(props, tickRate);
        this.canCarryWater = canCarryWater;
        this.canCarryLava = canCarryLava;
        this.cloggingProbability = cloggingProbability;
        this.fireBreakProbability = fireBreakProbability;
        this.fireDripProbability = fireDripProbability;
        this.wateringProbability = wateringProbability;
        this.waterDrippingProbability = waterDrippingProbability;
        this.lavaDrippingProbability = lavaDrippingProbability;
        this.waterFillingProbability = waterFillingProbability;
        this.lavaFillingProbability = lavaFillingProbability;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(FLUID, (Comparable)((Object)PipeFluid.NONE))).setValue((Property)OUTFLOW, (Comparable)Boolean.valueOf(false)));
    }

    public FluidPipe(BlockBehaviour.Properties props, FluidBlockSettings modSettings) {
        this(props, modSettings.tickRate(), modSettings.canCarryWater(), modSettings.canCarryLava(), modSettings.cloggingProbability(), modSettings.fireBreakProbability(), modSettings.fireDripProbability(), modSettings.wateringProbability(), modSettings.waterDrippingProbability(), modSettings.lavaDrippingProbability(), modSettings.waterFillingProbability(), modSettings.lavaFillingProbability());
    }

    @Override
    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FLUID, OUTFLOW});
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new FluidPipeEntity(pos, state);
    }

    private static boolean isOutFlowInDir(@NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull FlowingFluid fluid, @NotNull Direction dir) {
        BlockPos nPos = pos.relative(dir);
        BlockState nState = level.getBlockState(nPos);
        Block nBlock = nState.getBlock();
        if (nBlock instanceof FluidPipe) {
            boolean outflow = (Boolean)nState.getValue((Property)ModProperties.OUTFLOW);
            Direction facing = (Direction)nState.getValue((Property)BlockStateProperties.FACING);
            PipeFluid pipeFluid = (PipeFluid)((Object)nState.getValue(ModProperties.FLUID));
            return outflow && facing == dir.getOpposite() && (pipeFluid == PipeFluid.WATER && fluid == Fluids.WATER || pipeFluid == PipeFluid.LAVA && fluid == Fluids.LAVA);
        }
        return false;
    }

    public static boolean isOutflow(@NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull FlowingFluid fluid) {
        for (Direction dir : DIRECTIONS) {
            if (!FluidPipe.isOutFlowInDir(level, pos, fluid, dir)) continue;
            return true;
        }
        return false;
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.animateTick(state, level, pos, random);
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (facing != Direction.DOWN && facing != Direction.UP) {
            DripShowUtil.showDrip(level, pos, state, 0.1);
        }
    }

    @Override
    protected BlockState beforeTurning(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        FluidDispenseUtil.removeOutflow(level, pos, state);
        return (BlockState)super.beforeTurning(level, pos, state).setValue((Property)ModProperties.OUTFLOW, (Comparable)Boolean.valueOf(false));
    }

    protected void affectNeighborsAfterRemoval(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, boolean moved) {
        FluidDispenseUtil.removeOutflow((Level)level, pos, state);
        level.removeBlockEntity(pos);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        if (!level.isClientSide) {
            return FluidPipe.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.FLUID_PIPE_ENTITY.get()), FluidPipeEntity::serverTick);
        }
        return null;
    }

    @Override
    public boolean canCarryWater() {
        return this.canCarryWater;
    }

    @Override
    public boolean canCarryLava() {
        return this.canCarryLava;
    }

    @Override
    public float getCloggingProbability() {
        return this.cloggingProbability;
    }

    @Override
    public float getFireBreakProbability() {
        return this.fireBreakProbability;
    }

    @Override
    public float getFireDripProbability() {
        return this.fireDripProbability;
    }

    @Override
    public float getWateringProbability() {
        return this.wateringProbability;
    }

    @Override
    public float getWaterDrippingProbability() {
        return this.waterDrippingProbability;
    }

    @Override
    public float getLavaDrippingProbability() {
        return this.lavaDrippingProbability;
    }

    @Override
    public float getWaterFillingProbability() {
        return this.waterFillingProbability;
    }

    @Override
    public float getLavaFillingProbability() {
        return this.lavaFillingProbability;
    }

    @Override
    public FluidBlockSettings getFluidBlockSettings() {
        return FluidCarryBlock.super.getFluidBlockSettings();
    }

    @NotNull
    protected MapCodec<? extends FluidPipe> codec() {
        return CODEC;
    }
}

