/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.block.entity;

import eu.pintergabor.fluidpipes.block.BaseBlock;
import eu.pintergabor.fluidpipes.block.entity.BaseFittingEntity;
import eu.pintergabor.fluidpipes.block.util.DripActionUtil;
import eu.pintergabor.fluidpipes.block.util.FluidFittingUtil;
import eu.pintergabor.fluidpipes.block.util.FluidUtil;
import eu.pintergabor.fluidpipes.block.util.TickUtil;
import eu.pintergabor.fluidpipes.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class FluidFittingEntity
extends BaseFittingEntity {
    public FluidFittingEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModBlockEntities.FLUID_FITTING_ENTITY.get(), pos, state);
    }

    public static void serverTick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidFittingEntity entity) {
        boolean powered;
        TickUtil.TickPos tickPos = BaseBlock.getTickPos(level, state);
        ServerLevel serverLevel = (ServerLevel)level;
        if (tickPos == TickUtil.TickPos.START) {
            FluidFittingUtil.pull((Level)serverLevel, pos, state, entity);
            FluidUtil.clog(serverLevel, pos, state);
        }
        if (tickPos == TickUtil.TickPos.MIDDLE && !(powered = ((Boolean)state.getValueOrElse((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false))).booleanValue())) {
            DripActionUtil.dripDown(serverLevel, pos, state);
            FluidFittingUtil.breakFire(serverLevel, pos, state);
        }
    }
}

