/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.block.entity;

import eu.pintergabor.fluidpipes.block.BaseBlock;
import eu.pintergabor.fluidpipes.block.entity.BasePipeEntity;
import eu.pintergabor.fluidpipes.block.util.DripActionUtil;
import eu.pintergabor.fluidpipes.block.util.FluidDispenseUtil;
import eu.pintergabor.fluidpipes.block.util.FluidPullUtil;
import eu.pintergabor.fluidpipes.block.util.FluidPushUtil;
import eu.pintergabor.fluidpipes.block.util.FluidUtil;
import eu.pintergabor.fluidpipes.block.util.TickUtil;
import eu.pintergabor.fluidpipes.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class FluidPipeEntity
extends BasePipeEntity {
    public FluidPipeEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModBlockEntities.FLUID_PIPE_ENTITY.get(), pos, state);
    }

    public static void serverTick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidPipeEntity entity) {
        TickUtil.TickPos tickPos = BaseBlock.getTickPos(level, state);
        ServerLevel serverLevel = (ServerLevel)level;
        if (tickPos == TickUtil.TickPos.START) {
            FluidPullUtil.pull((Level)serverLevel, pos, state, entity);
            FluidUtil.clog(serverLevel, pos, state);
        }
        if (tickPos == TickUtil.TickPos.MIDDLE) {
            FluidPushUtil.push(serverLevel, pos, state);
            FluidDispenseUtil.dispense(level, pos, state);
            DripActionUtil.dripDown(serverLevel, pos, state);
            FluidDispenseUtil.breakFire(serverLevel, pos, state);
        }
    }
}

