/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.block.util;

import eu.pintergabor.fluidpipes.block.CanCarryFluid;
import eu.pintergabor.fluidpipes.block.properties.PipeFluid;
import eu.pintergabor.fluidpipes.registry.util.ModProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import org.jetbrains.annotations.NotNull;

public final class DripActionUtil {
    private DripActionUtil() {
    }

    private static boolean dripWaterOnCauldron(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        level.setBlockAndUpdate(pos, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)BlockStateProperties.LEVEL_CAULDRON, (Comparable)Integer.valueOf(1)));
        return true;
    }

    private static boolean dripLavaOnCauldron(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        level.setBlockAndUpdate(pos, Blocks.LAVA_CAULDRON.defaultBlockState());
        return true;
    }

    private static boolean dripWaterOnWaterCauldron(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)BlockStateProperties.LEVEL_CAULDRON));
        return true;
    }

    private static boolean dripWaterOnDirt(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        level.setBlockAndUpdate(pos, Blocks.MUD.defaultBlockState());
        return true;
    }

    private static boolean dripWaterOnFire(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        level.destroyBlock(pos, true);
        return true;
    }

    public static boolean dripWaterOnBlock(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Block block = state.getBlock();
        if (block == Blocks.CAULDRON) {
            return DripActionUtil.dripWaterOnCauldron(level, pos, state);
        }
        if (block == Blocks.WATER_CAULDRON) {
            return (Integer)state.getValue((Property)BlockStateProperties.LEVEL_CAULDRON) < 3 && DripActionUtil.dripWaterOnWaterCauldron(level, pos, state);
        }
        if (block == Blocks.DIRT) {
            return DripActionUtil.dripWaterOnDirt(level, pos, state);
        }
        if (block == Blocks.FIRE) {
            return DripActionUtil.dripWaterOnFire(level, pos, state);
        }
        return false;
    }

    public static boolean dripLavaOnBlock(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Block block = state.getBlock();
        if (block == Blocks.CAULDRON) {
            return DripActionUtil.dripLavaOnCauldron(level, pos, state);
        }
        return false;
    }

    public static boolean dripLavaStartFire(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        BlockPos uPos = pos.above();
        BlockState uState = level.getBlockState(uPos);
        if (uState.isAir()) {
            level.setBlockAndUpdate(uPos, Blocks.FIRE.defaultBlockState());
            return true;
        }
        return false;
    }

    public static boolean dripWaterDown(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        boolean waterDripping;
        CanCarryFluid block = (CanCarryFluid)state.getBlock();
        boolean bl = waterDripping = level.random.nextFloat() < block.getWaterDrippingProbability();
        if (waterDripping) {
            for (int dy = 1; dy <= 12; ++dy) {
                BlockPos nPos = pos.below(dy);
                BlockState nState = level.getBlockState(nPos);
                if (!level.getFluidState(nPos).isEmpty()) {
                    return false;
                }
                if (DripActionUtil.dripWaterOnBlock(level, nPos, nState)) {
                    return true;
                }
                if (nState.getCollisionShape((BlockGetter)level, nPos) == Shapes.empty()) continue;
                return false;
            }
        }
        return false;
    }

    public static boolean dripLavaDown(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        CanCarryFluid block = (CanCarryFluid)state.getBlock();
        boolean lavaDripping = level.random.nextFloat() < block.getLavaDrippingProbability();
        for (int dy = 1; dy <= 12; ++dy) {
            BlockPos nPos = pos.below(dy);
            BlockState nState = level.getBlockState(nPos);
            if (!level.getFluidState(nPos).isEmpty()) {
                return false;
            }
            if (lavaDripping && DripActionUtil.dripLavaOnBlock(level, nPos, nState)) {
                return true;
            }
            if (nState.getCollisionShape((BlockGetter)level, nPos) == Shapes.empty()) continue;
            boolean startFire = level.random.nextFloat() < block.getFireDripProbability();
            return startFire && DripActionUtil.dripLavaStartFire(level, nPos, nState);
        }
        return false;
    }

    public static boolean dripDown(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        PipeFluid fluid = (PipeFluid)((Object)state.getValue(ModProperties.FLUID));
        return switch (fluid) {
            default -> throw new MatchException(null, null);
            case PipeFluid.WATER -> DripActionUtil.dripWaterDown(level, pos, state);
            case PipeFluid.LAVA -> DripActionUtil.dripLavaDown(level, pos, state);
            case PipeFluid.NONE -> false;
        };
    }
}

