/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.block.util;

import eu.pintergabor.fluidpipes.block.CanCarryFluid;
import eu.pintergabor.fluidpipes.block.properties.PipeFluid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class DripShowUtil {
    private DripShowUtil() {
    }

    private static float getDripRnd(RandomSource random) {
        return random.nextFloat() / 2.0f - 0.25f;
    }

    public static void showDrip(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, double yOffset) {
        boolean lavaDripping;
        RandomSource random = level.random;
        CanCarryFluid block = (CanCarryFluid)state.getBlock();
        PipeFluid fluid = CanCarryFluid.getFluid(state);
        boolean waterDripping = random.nextFloat() < block.getWaterDrippingProbability() + block.getWateringProbability() * 0.2f;
        boolean bl = lavaDripping = random.nextFloat() < block.getLavaDrippingProbability() * 100.0f;
        if (waterDripping && fluid == PipeFluid.WATER || lavaDripping && fluid == PipeFluid.LAVA) {
            float rx = DripShowUtil.getDripRnd(random);
            float rz = DripShowUtil.getDripRnd(random);
            Vec3 pPos = pos.getBottomCenter().add((double)rx, yOffset, (double)rz);
            level.addParticle((ParticleOptions)(fluid == PipeFluid.WATER ? ParticleTypes.DRIPPING_WATER : ParticleTypes.DRIPPING_LAVA), pPos.x(), pPos.y(), pPos.z(), 0.0, 0.0, 0.0);
        }
    }
}

