/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.block.util;

import eu.pintergabor.fluidpipes.block.CanCarryFluid;
import eu.pintergabor.fluidpipes.block.properties.PipeFluid;
import eu.pintergabor.fluidpipes.registry.util.ModProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public final class FluidDispenseUtil {
    private FluidDispenseUtil() {
    }

    public static boolean startDispense(@NotNull Level level, @NotNull BlockPos frontPos, @NotNull BlockState frontState, @NotNull PipeFluid pipeFluid) {
        if (frontState.isAir()) {
            if (pipeFluid == PipeFluid.WATER) {
                level.setBlockAndUpdate(frontPos, Blocks.WATER.defaultBlockState());
                return true;
            }
            if (pipeFluid == PipeFluid.LAVA) {
                level.setBlockAndUpdate(frontPos, Blocks.LAVA.defaultBlockState());
                return true;
            }
        }
        return false;
    }

    public static boolean stopDispense(@NotNull Level level, @NotNull BlockPos frontPos, @NotNull BlockState frontState, @NotNull PipeFluid pipeFluid) {
        if (frontState.is(Blocks.WATER)) {
            if (pipeFluid != PipeFluid.WATER) {
                level.setBlockAndUpdate(frontPos, Blocks.AIR.defaultBlockState());
                return true;
            }
        } else if (frontState.is(Blocks.LAVA)) {
            if (pipeFluid != PipeFluid.LAVA) {
                level.setBlockAndUpdate(frontPos, Blocks.AIR.defaultBlockState());
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public static void removeOutflow(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        PipeFluid fluid = (PipeFluid)((Object)state.getValue(ModProperties.FLUID));
        boolean outflow = (Boolean)state.getValue((Property)ModProperties.OUTFLOW);
        BlockPos frontPos = pos.relative(facing);
        BlockState frontState = level.getBlockState(frontPos);
        if (outflow) {
            if (frontState.is(Blocks.WATER)) {
                if (fluid == PipeFluid.WATER) {
                    level.setBlockAndUpdate(frontPos, Blocks.AIR.defaultBlockState());
                }
            } else if (frontState.is(Blocks.LAVA) && fluid == PipeFluid.LAVA) {
                level.setBlockAndUpdate(frontPos, Blocks.AIR.defaultBlockState());
            }
        }
    }

    public static boolean breakFire(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        PipeFluid fluid = (PipeFluid)((Object)state.getValue(ModProperties.FLUID));
        boolean waterlogged = (Boolean)state.getValueOrElse((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        if (!waterlogged && fluid == PipeFluid.LAVA) {
            boolean fire;
            CanCarryFluid block = (CanCarryFluid)state.getBlock();
            boolean bl = fire = level.random.nextFloat() < block.getFireBreakProbability();
            if (fire) {
                level.setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                return true;
            }
        }
        return false;
    }

    public static boolean dispense(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        boolean outflow = (Boolean)state.getValue((Property)ModProperties.OUTFLOW);
        PipeFluid pipeFluid = (PipeFluid)((Object)state.getValue(ModProperties.FLUID));
        BlockPos frontPos = pos.relative(facing);
        BlockState frontState = level.getBlockState(frontPos);
        Block frontBlock = frontState.getBlock();
        if (!outflow) {
            if (FluidDispenseUtil.startDispense(level, frontPos, frontState, pipeFluid)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ModProperties.OUTFLOW, (Comparable)Boolean.valueOf(true)));
                return true;
            }
        } else if (FluidDispenseUtil.stopDispense(level, frontPos, frontState, pipeFluid)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ModProperties.OUTFLOW, (Comparable)Boolean.valueOf(false)));
            return true;
        }
        return false;
    }
}

