/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.block.util;

import eu.pintergabor.fluidpipes.block.BaseBlock;
import eu.pintergabor.fluidpipes.block.CanCarryFluid;
import eu.pintergabor.fluidpipes.block.FluidFitting;
import eu.pintergabor.fluidpipes.block.entity.FluidFittingEntity;
import eu.pintergabor.fluidpipes.block.properties.PipeFluid;
import eu.pintergabor.fluidpipes.block.util.FluidUtil;
import eu.pintergabor.fluidpipes.registry.util.ModProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public final class FluidFittingUtil {
    private FluidFittingUtil() {
    }

    public static PipeFluid sideSourceFluid(@NotNull Level level, @NotNull BlockPos pos, boolean canCarryWater, boolean canCarryLava) {
        for (Direction d : BaseBlock.DIRECTIONS) {
            PipeFluid nFluid = FluidUtil.oneSideSourceFluid(level, pos, d, canCarryWater, canCarryLava);
            if (nFluid == PipeFluid.NONE) continue;
            return nFluid;
        }
        return PipeFluid.NONE;
    }

    public static boolean breakFire(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        PipeFluid fluid = (PipeFluid)((Object)state.getValue(ModProperties.FLUID));
        boolean waterlogged = (Boolean)state.getValueOrElse((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        if (!waterlogged && fluid == PipeFluid.LAVA) {
            boolean fire;
            CanCarryFluid block = (CanCarryFluid)state.getBlock();
            boolean bl = fire = level.random.nextFloat() < block.getFireBreakProbability();
            if (fire) {
                level.setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                return true;
            }
        }
        return false;
    }

    public static boolean pull(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidFittingEntity entity) {
        boolean canCarryLava;
        PipeFluid pipeFluid = (PipeFluid)((Object)state.getValue(ModProperties.FLUID));
        FluidFitting block = (FluidFitting)state.getBlock();
        boolean canCarryWater = block.canCarryWater();
        PipeFluid sideFluid = FluidFittingUtil.sideSourceFluid(level, pos, canCarryWater, canCarryLava = block.canCarryLava());
        if (sideFluid != PipeFluid.NONE) {
            if (pipeFluid != sideFluid) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(ModProperties.FLUID, (Comparable)((Object)sideFluid)));
                return true;
            }
        } else if (pipeFluid != PipeFluid.NONE) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(ModProperties.FLUID, (Comparable)((Object)PipeFluid.NONE)));
            return true;
        }
        return false;
    }
}

