/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.block.util;

import eu.pintergabor.fluidpipes.block.BaseBlock;
import eu.pintergabor.fluidpipes.block.BaseFitting;
import eu.pintergabor.fluidpipes.block.BasePipe;
import eu.pintergabor.fluidpipes.block.FluidPipe;
import eu.pintergabor.fluidpipes.block.entity.FluidPipeEntity;
import eu.pintergabor.fluidpipes.block.properties.PipeFluid;
import eu.pintergabor.fluidpipes.block.util.FluidUtil;
import eu.pintergabor.fluidpipes.registry.util.ModProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public final class FluidPullUtil {
    private FluidPullUtil() {
    }

    private static boolean isNaturalWaterSource(@NotNull BlockState state) {
        Block block = state.getBlock();
        if (block == Blocks.WATER) {
            return true;
        }
        if (block == Blocks.WATER_CAULDRON && (Integer)state.getValue((Property)BlockStateProperties.LEVEL_CAULDRON) == 3) {
            return true;
        }
        return (Boolean)state.getValueOrElse((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)) != false;
    }

    private static boolean isModWaterSource(@NotNull BlockState state) {
        Block block = state.getBlock();
        if (block instanceof BasePipe && state.getValueOrElse(ModProperties.FLUID, (Comparable)((Object)PipeFluid.NONE)) == PipeFluid.WATER) {
            return true;
        }
        return block instanceof BaseFitting && (Boolean)state.getValueOrElse((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)) == false && state.getValueOrElse(ModProperties.FLUID, (Comparable)((Object)PipeFluid.NONE)) == PipeFluid.WATER;
    }

    public static boolean isWaterSource(@NotNull BlockState state) {
        return FluidPullUtil.isNaturalWaterSource(state) || FluidPullUtil.isModWaterSource(state);
    }

    private static boolean isNaturalLavaSource(@NotNull BlockState state) {
        Block block = state.getBlock();
        if (block == Blocks.LAVA) {
            return true;
        }
        return block == Blocks.LAVA_CAULDRON;
    }

    private static boolean isModLavaSource(@NotNull BlockState state) {
        Block block = state.getBlock();
        if (block instanceof BasePipe && state.getValueOrElse(ModProperties.FLUID, (Comparable)((Object)PipeFluid.NONE)) == PipeFluid.LAVA) {
            return true;
        }
        return block instanceof BaseFitting && (Boolean)state.getValueOrElse((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)) == false && state.getValueOrElse(ModProperties.FLUID, (Comparable)((Object)PipeFluid.NONE)) == PipeFluid.LAVA;
    }

    public static boolean isLavaSource(@NotNull BlockState state) {
        return FluidPullUtil.isNaturalLavaSource(state) || FluidPullUtil.isModLavaSource(state);
    }

    public static PipeFluid sideSourceFluid(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction facing, @NotNull Direction opposite, boolean canCarryWater, boolean canCarryLava) {
        for (Direction d : BaseBlock.DIRECTIONS) {
            PipeFluid nFluid;
            if (d == facing || d == opposite || (nFluid = FluidUtil.oneSideSourceFluid(level, pos, d, canCarryWater, canCarryLava)) == PipeFluid.NONE) continue;
            return nFluid;
        }
        return PipeFluid.NONE;
    }

    public static PipeFluid backSourceFluid(@NotNull BlockState backState, @NotNull PipeFluid pipeFluid, boolean canCarryWater, boolean canCarryLava) {
        if (canCarryLava && FluidPullUtil.isLavaSource(backState)) {
            return PipeFluid.LAVA;
        }
        if (canCarryWater && FluidPullUtil.isWaterSource(backState)) {
            return PipeFluid.WATER;
        }
        return PipeFluid.NONE;
    }

    public static boolean pull(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidPipeEntity entity) {
        Direction facing = (Direction)state.getValue(BasePipe.FACING);
        Direction opposite = facing.getOpposite();
        PipeFluid pipeFluid = (PipeFluid)((Object)state.getValue(ModProperties.FLUID));
        FluidPipe block = (FluidPipe)state.getBlock();
        boolean canCarryWater = block.canCarryWater();
        boolean canCarryLava = block.canCarryLava();
        BlockPos backPos = pos.relative(opposite);
        BlockState backState = level.getBlockState(backPos);
        PipeFluid backFluid = FluidPullUtil.backSourceFluid(backState, pipeFluid, canCarryWater, canCarryLava);
        if (backFluid != PipeFluid.NONE) {
            if (pipeFluid != backFluid) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(ModProperties.FLUID, (Comparable)((Object)backFluid)));
                return true;
            }
        } else {
            PipeFluid sideFluid = FluidPullUtil.sideSourceFluid(level, pos, facing, opposite, canCarryWater, canCarryLava);
            if (sideFluid != PipeFluid.NONE) {
                if (pipeFluid != sideFluid) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue(ModProperties.FLUID, (Comparable)((Object)sideFluid)));
                    return true;
                }
            } else if (pipeFluid != PipeFluid.NONE) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(ModProperties.FLUID, (Comparable)((Object)PipeFluid.NONE)));
                return true;
            }
        }
        return false;
    }
}

