/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.block.util;

import eu.pintergabor.fluidpipes.block.BasePipe;
import eu.pintergabor.fluidpipes.block.FluidPipe;
import eu.pintergabor.fluidpipes.block.properties.PipeFluid;
import eu.pintergabor.fluidpipes.block.util.DripActionUtil;
import eu.pintergabor.fluidpipes.registry.util.ModProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public final class FluidPushUtil {
    private FluidPushUtil() {
    }

    private static boolean fuelFurnace(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        ItemStack stack;
        Container inventory;
        Block block = state.getBlock();
        if (block instanceof AbstractFurnaceBlock && (inventory = HopperBlockEntity.getContainerAt((Level)level, (BlockPos)pos)) != null && (stack = inventory.getItem(1)).is(Items.BUCKET)) {
            inventory.setItem(1, new ItemStack((ItemLike)Items.LAVA_BUCKET));
            return true;
        }
        return false;
    }

    public static boolean pushWaterToBlock(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return DripActionUtil.dripWaterOnBlock(level, pos, state);
    }

    public static boolean pushLavaToBlock(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return DripActionUtil.dripLavaOnBlock(level, pos, state) || FluidPushUtil.fuelFurnace(level, pos, state);
    }

    public static boolean push(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Direction facing = (Direction)state.getValue(BasePipe.FACING);
        Direction opposite = facing.getOpposite();
        PipeFluid pipeFluid = (PipeFluid)((Object)state.getValue(ModProperties.FLUID));
        FluidPipe block = (FluidPipe)state.getBlock();
        BlockPos frontPos = pos.relative(facing);
        BlockState frontState = level.getBlockState(frontPos);
        Block frontBlock = frontState.getBlock();
        if (pipeFluid != PipeFluid.NONE) {
            boolean lavaFilling;
            float rnd = level.random.nextFloat();
            boolean waterFilling = rnd < block.getWaterFillingProbability();
            boolean bl = lavaFilling = rnd < block.getLavaFillingProbability();
            if (lavaFilling && pipeFluid == PipeFluid.LAVA) {
                return FluidPushUtil.pushLavaToBlock(level, frontPos, frontState);
            }
            if (waterFilling && pipeFluid == PipeFluid.WATER) {
                return FluidPushUtil.pushWaterToBlock(level, frontPos, frontState);
            }
        }
        return false;
    }
}

