/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.block.util;

import eu.pintergabor.fluidpipes.block.BasePipe;
import eu.pintergabor.fluidpipes.block.CanCarryFluid;
import eu.pintergabor.fluidpipes.block.FluidPipe;
import eu.pintergabor.fluidpipes.block.properties.PipeFluid;
import eu.pintergabor.fluidpipes.registry.util.ModProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public final class FluidUtil {
    private FluidUtil() {
    }

    public static boolean clog(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        CanCarryFluid block = (CanCarryFluid)state.getBlock();
        PipeFluid fluid = (PipeFluid)((Object)state.getValueOrElse(ModProperties.FLUID, (Comparable)((Object)PipeFluid.NONE)));
        if (fluid != PipeFluid.NONE) {
            boolean clogging;
            boolean bl = clogging = level.random.nextFloat() < block.getCloggingProbability();
            if (clogging) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(ModProperties.FLUID, (Comparable)((Object)PipeFluid.NONE)));
                return true;
            }
        }
        return false;
    }

    public static PipeFluid oneSideSourceFluid(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction dir, boolean canCarryWater, boolean canCarryLava) {
        BlockState nState = level.getBlockState(pos.relative(dir));
        Block nBlock = nState.getBlock();
        if (nBlock instanceof FluidPipe && nState.getValue(BasePipe.FACING) == dir.getOpposite()) {
            PipeFluid nFluid = (PipeFluid)((Object)nState.getValue(ModProperties.FLUID));
            if (canCarryWater && nFluid == PipeFluid.WATER || canCarryLava && nFluid == PipeFluid.LAVA) {
                return nFluid;
            }
        }
        return PipeFluid.NONE;
    }
}

