/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.block.util;

import eu.pintergabor.fluidpipes.block.CanCarryFluid;
import eu.pintergabor.fluidpipes.block.properties.PipeFluid;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class WateringUtil {
    private WateringUtil() {
    }

    private static boolean isLeakingWater(@NotNull Entity entity, @NotNull Vec3 blockCenterPos) {
        BlockHitResult hitResult;
        BlockPos pos;
        Vec3 entityPos = entity.position();
        Level level = entity.level();
        BlockState state = level.getBlockState(pos = (hitResult = level.clip(new ClipContext(entityPos, blockCenterPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity))).getBlockPos());
        Block block = state.getBlock();
        if (block instanceof CanCarryFluid) {
            CanCarryFluid block2 = (CanCarryFluid)block;
            boolean watering = level.random.nextFloat() < block2.getWateringProbability();
            PipeFluid fluid = CanCarryFluid.getFluid(state);
            return watering && fluid == PipeFluid.WATER;
        }
        return false;
    }

    private static boolean isLeakingWater(@NotNull Level level, @NotNull BlockPos blockPos) {
        BlockState state = level.getBlockState(blockPos);
        Block block = state.getBlock();
        if (block instanceof CanCarryFluid) {
            CanCarryFluid block2 = (CanCarryFluid)block;
            boolean watering = level.random.nextFloat() < block2.getWateringProbability();
            PipeFluid fluid = CanCarryFluid.getFluid(state);
            return watering && fluid == PipeFluid.WATER;
        }
        return false;
    }

    public static boolean isWaterPipeNearby(@NotNull Entity entity, int range) {
        int targetX = entity.getBlockX();
        int targetY = entity.getBlockY();
        int targetZ = entity.getBlockZ();
        for (int y = targetY; y <= targetY + 12; ++y) {
            for (int x = targetX - range; x <= targetX + range; ++x) {
                for (int z = targetZ - range; z <= targetZ + range; ++z) {
                    if (!WateringUtil.isLeakingWater(entity, new Vec3((double)x + 0.5, (double)y + 0.5, (double)z + 0.5))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isWaterPipeNearby(@NotNull Level level, @NotNull BlockPos pos, int range) {
        int targetX = pos.getX();
        int targetY = pos.getY();
        int targetZ = pos.getZ();
        for (int y = targetY; y <= targetY + 12; ++y) {
            for (int x = targetX - range; x <= targetX + range; ++x) {
                for (int z = targetZ - range; z <= targetZ + range; ++z) {
                    if (!WateringUtil.isLeakingWater(level, new BlockPos(x, y, z))) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

