/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.datagen.model;

import eu.pintergabor.fluidpipes.Global;
import eu.pintergabor.fluidpipes.block.BasePipe;
import eu.pintergabor.fluidpipes.registry.ModBlocks;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public final class ModModelProvider
extends ModelProvider {
    private static final ModelTemplate PIPE_MODEL = new ModelTemplate(Optional.of(Global.modId("block/template_pipe")), Optional.empty(), new TextureSlot[]{TextureSlot.SIDE, TextureSlot.FRONT});
    private static final ModelTemplate PIPE_MODEL_BACK = new ModelTemplate(Optional.of(Global.modId("block/template_pipe_back_extension")), Optional.empty(), new TextureSlot[]{TextureSlot.SIDE, TextureSlot.FRONT});
    private static final ModelTemplate PIPE_MODEL_BACK_SMOOTH = new ModelTemplate(Optional.of(Global.modId("block/template_pipe_back_smooth")), Optional.empty(), new TextureSlot[]{TextureSlot.SIDE});
    private static final ModelTemplate PIPE_MODEL_DOUBLE_EXTENSION = new ModelTemplate(Optional.of(Global.modId("block/template_pipe_double_extension")), Optional.empty(), new TextureSlot[]{TextureSlot.SIDE});
    private static final ModelTemplate PIPE_MODEL_FRONT_EXTENSION = new ModelTemplate(Optional.of(Global.modId("block/template_pipe_front_extension")), Optional.empty(), new TextureSlot[]{TextureSlot.SIDE, TextureSlot.FRONT});
    private static final ModelTemplate PIPE_MODEL_SMOOTH = new ModelTemplate(Optional.of(Global.modId("block/template_pipe_smooth")), Optional.empty(), new TextureSlot[]{TextureSlot.SIDE, TextureSlot.FRONT});
    private static final ModelTemplate FITTING_MODEL = new ModelTemplate(Optional.of(Global.modId("block/template_fitting")), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});

    public ModModelProvider(PackOutput output) {
        super(output, "fluidpipes");
    }

    private static void createPipe(@NotNull BlockModelGenerators generators, Block pipeBlock) {
        TextureMapping pipeTextureMapping = new TextureMapping();
        pipeTextureMapping.put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)pipeBlock));
        pipeTextureMapping.put(TextureSlot.FRONT, TextureMapping.getBlockTexture((Block)pipeBlock, (String)"_front"));
        PIPE_MODEL.create(pipeBlock, pipeTextureMapping, generators.modelOutput);
        PIPE_MODEL_BACK.createWithSuffix(pipeBlock, "_back_extension", pipeTextureMapping, generators.modelOutput);
        PIPE_MODEL_BACK_SMOOTH.createWithSuffix(pipeBlock, "_back_smooth", pipeTextureMapping, generators.modelOutput);
        PIPE_MODEL_DOUBLE_EXTENSION.createWithSuffix(pipeBlock, "_double_extension", pipeTextureMapping, generators.modelOutput);
        PIPE_MODEL_FRONT_EXTENSION.createWithSuffix(pipeBlock, "_front_extension", pipeTextureMapping, generators.modelOutput);
        PIPE_MODEL_SMOOTH.createWithSuffix(pipeBlock, "_smooth", pipeTextureMapping, generators.modelOutput);
        ResourceLocation model = ModelLocationUtils.getModelLocation((Block)pipeBlock);
        ResourceLocation frontExtensionModel = ModelLocationUtils.getModelLocation((Block)pipeBlock, (String)"_front_extension");
        ResourceLocation doubleExtensionModel = ModelLocationUtils.getModelLocation((Block)pipeBlock, (String)"_double_extension");
        ResourceLocation backExtensionModel = ModelLocationUtils.getModelLocation((Block)pipeBlock, (String)"_back_extension");
        ResourceLocation smoothModel = ModelLocationUtils.getModelLocation((Block)pipeBlock, (String)"_smooth");
        ResourceLocation backSmoothModel = ModelLocationUtils.getModelLocation((Block)pipeBlock, (String)"_back_smooth");
        generators.registerSimpleItemModel(pipeBlock, model);
        generators.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)pipeBlock).with((PropertyDispatch)PropertyDispatch.initial((Property)BasePipe.FRONT_CONNECTED, (Property)BasePipe.BACK_CONNECTED, (Property)BasePipe.SMOOTH).select((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), (Object)BlockModelGenerators.plainVariant((ResourceLocation)model)).select((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), (Object)BlockModelGenerators.plainVariant((ResourceLocation)smoothModel)).select((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), (Object)BlockModelGenerators.plainVariant((ResourceLocation)backExtensionModel)).select((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), (Object)BlockModelGenerators.plainVariant((ResourceLocation)backSmoothModel)).select((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), (Object)BlockModelGenerators.plainVariant((ResourceLocation)frontExtensionModel)).select((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), (Object)BlockModelGenerators.plainVariant((ResourceLocation)frontExtensionModel)).select((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), (Object)BlockModelGenerators.plainVariant((ResourceLocation)doubleExtensionModel)).select((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), (Object)BlockModelGenerators.plainVariant((ResourceLocation)doubleExtensionModel))).with(BlockModelGenerators.ROTATION_FACING));
    }

    private static void createFitting(@NotNull BlockModelGenerators generators, Block fittingBlock) {
        TextureMapping fittingTextureMapping = new TextureMapping();
        fittingTextureMapping.put(TextureSlot.TEXTURE, TextureMapping.getBlockTexture((Block)fittingBlock));
        FITTING_MODEL.create(fittingBlock, fittingTextureMapping, generators.modelOutput);
        ResourceLocation model = ModelLocationUtils.getModelLocation((Block)fittingBlock);
        generators.registerSimpleItemModel(fittingBlock, model);
        generators.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)fittingBlock, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)model)));
    }

    protected void registerModels(@NotNull BlockModelGenerators blockModels, @NotNull ItemModelGenerators itemModels) {
        Arrays.stream(ModBlocks.PIPES).forEach(b -> ModModelProvider.createPipe(blockModels, (Block)b.get()));
        Arrays.stream(ModBlocks.FITTINGS).forEach(b -> ModModelProvider.createFitting(blockModels, (Block)b.get()));
    }
}

