/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.datagen.recipe;

import eu.pintergabor.fluidpipes.registry.ModBlocks;
import java.util.stream.IntStream;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public final class ModRecipeGenerator
extends RecipeProvider {
    public ModRecipeGenerator(HolderLookup.Provider registries, RecipeOutput output) {
        super(registries, output);
    }

    private ShapedRecipeBuilder createPipeRecipe(RecipeCategory recipeCategory, ItemLike input, ItemLike output, int outputCount) {
        return this.shaped(recipeCategory, output, outputCount).define(Character.valueOf('#'), input).pattern("###").pattern("   ").pattern("###").unlockedBy(ModRecipeGenerator.getHasName((ItemLike)input), this.has(input));
    }

    private ShapedRecipeBuilder createFittingRecipe(RecipeCategory recipeCategory, ItemLike input, ItemLike output, int outputCount) {
        return this.shaped(recipeCategory, output, outputCount).define(Character.valueOf('#'), input).pattern("###").pattern("# #").pattern("###").unlockedBy(ModRecipeGenerator.getHasName((ItemLike)input), this.has(input));
    }

    private void createWoodenPipeRecipes() {
        ItemLike[] WOODEN_PLANKS = new ItemLike[]{Items.OAK_PLANKS, Items.SPRUCE_PLANKS, Items.BIRCH_PLANKS, Items.JUNGLE_PLANKS, Items.ACACIA_PLANKS, Items.CHERRY_PLANKS, Items.DARK_OAK_PLANKS, Items.PALE_OAK_PLANKS, Items.MANGROVE_PLANKS, Items.BAMBOO_PLANKS};
        IntStream.range(0, ModBlocks.WOODEN_PIPES.length).forEach(i -> this.createPipeRecipe(RecipeCategory.MISC, WOODEN_PLANKS[i], (ItemLike)ModBlocks.WOODEN_PIPES[i], 6).save(this.output));
    }

    private void createWoodenFittingRecipes() {
        IntStream.range(0, ModBlocks.WOODEN_PIPES.length).forEach(i -> this.createFittingRecipe(RecipeCategory.MISC, (ItemLike)ModBlocks.WOODEN_PIPES[i], (ItemLike)ModBlocks.WOODEN_FITTINGS[i], 8).save(this.output));
    }

    private void createStonePipeRecipes() {
        ItemLike[] STONES1 = new ItemLike[]{Items.STONE, Items.DEEPSLATE, Items.ANDESITE, Items.DIORITE, Items.GRANITE, Items.BASALT, Items.SANDSTONE, Items.TUFF, Items.OBSIDIAN, Items.NETHERRACK};
        ItemLike[] STONES2 = new ItemLike[]{Items.COBBLESTONE, Items.COBBLED_DEEPSLATE};
        IntStream.range(0, STONES1.length).forEach(i -> this.createPipeRecipe(RecipeCategory.MISC, STONES1[i], (ItemLike)ModBlocks.STONE_PIPES[i], 6).save(this.output));
        IntStream.range(0, STONES2.length).forEach(i -> this.createPipeRecipe(RecipeCategory.MISC, STONES2[i], (ItemLike)ModBlocks.STONE_PIPES[i], 6).save(this.output, String.valueOf(RecipeBuilder.getDefaultRecipeId(ModBlocks.STONE_PIPES[i])) + "2"));
    }

    private void createStoneFittingRecipes() {
        IntStream.range(0, ModBlocks.STONE_PIPES.length).forEach(i -> this.createFittingRecipe(RecipeCategory.MISC, (ItemLike)ModBlocks.STONE_PIPES[i], (ItemLike)ModBlocks.STONE_FITTINGS[i], 8).save(this.output));
    }

    public void buildRecipes() {
        this.createWoodenPipeRecipes();
        this.createWoodenFittingRecipes();
        this.createStonePipeRecipes();
        this.createStoneFittingRecipes();
    }
}

