/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.datagen.tag;

import eu.pintergabor.fluidpipes.registry.ModBlocks;
import eu.pintergabor.fluidpipes.tag.ModItemTags;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;

public final class ModItemTagProvider
extends ItemTagsProvider {
    public ModItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider) {
        super(output, lookupProvider, blockTagProvider, "fluidpipes");
    }

    private void add(TagKey<Item> key, DeferredBlock<? extends Block>[] blocks) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender builder = this.tag(key);
        Arrays.stream(blocks).map(DeferredBlock::asItem).forEach(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)builder).add(arg_0));
    }

    protected void addTags(@NotNull HolderLookup.Provider wrapperLookup) {
        this.add(ModItemTags.WOODEN_PIPES, ModBlocks.WOODEN_PIPES);
        this.add(ModItemTags.STONE_PIPES, ModBlocks.STONE_PIPES);
        this.add(ModItemTags.WOODEN_FITTINGS, ModBlocks.WOODEN_FITTINGS);
        this.add(ModItemTags.STONE_FITTINGS, ModBlocks.STONE_FITTINGS);
        this.tag(ModItemTags.PIPES_AND_FITTINGS).addTag(ModItemTags.WOODEN_PIPES).addTag(ModItemTags.WOODEN_FITTINGS).addTag(ModItemTags.STONE_PIPES).addTag(ModItemTags.STONE_FITTINGS);
    }
}

