/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import eu.pintergabor.fluidpipes.block.util.WateringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Unique
    private boolean fluidPipes$hadWaterPipeNearby;

    @Shadow
    public abstract boolean removeTag(String var1);

    @Inject(at={@At(value="HEAD")}, method={"updateInWaterStateAndDoFluidPushing"})
    private void updateInWaterState(CallbackInfoReturnable<Boolean> info) {
        if (!this.level().isClientSide) {
            Entity that = (Entity)this;
            this.fluidPipes$hadWaterPipeNearby = WateringUtil.isWaterPipeNearby(that, 2);
        }
    }

    @ModifyReturnValue(at={@At(value="RETURN")}, method={"isInRain"})
    private boolean isInRain(boolean original) {
        return original || this.fluidPipes$hadWaterPipeNearby;
    }

    @Shadow
    public abstract Level level();
}

