/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.mixin;

import eu.pintergabor.fluidpipes.block.FluidPipe;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LiquidBlock.class})
public abstract class LiquidBlockMixin {
    @Final
    @Shadow
    public FlowingFluid fluid;

    @Inject(at={@At(value="HEAD")}, method={"pickupBlock"}, cancellable=true)
    private void pickupBlock(@Nullable LivingEntity entity, LevelAccessor level, BlockPos pos, BlockState state, CallbackInfoReturnable<ItemStack> cir) {
        if (FluidPipe.isOutflow((BlockGetter)level, pos, this.fluid)) {
            cir.setReturnValue((Object)ItemStack.EMPTY);
        }
    }
}

