/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.fluidpipes.registry.util;

import eu.pintergabor.fluidpipes.block.FluidFitting;
import eu.pintergabor.fluidpipes.block.FluidPipe;
import eu.pintergabor.fluidpipes.block.settings.FluidBlockSettings;
import eu.pintergabor.fluidpipes.registry.ModRegistries;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;

public final class ModBlocksRegister {
    private ModBlocksRegister() {
    }

    @NotNull
    private static <T extends Block> DeferredBlock<T> registerBlock(@NotNull String path, @NotNull Function<BlockBehaviour.Properties, T> factory, BlockBehaviour.Properties props) {
        return ModRegistries.BLOCKS.register(path, id -> (Block)factory.apply(props.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id))));
    }

    @NotNull
    private static <T extends Block> DeferredBlock<T> registerBlockAndItem(@NotNull String path, @NotNull Function<BlockBehaviour.Properties, T> factory, @NotNull BlockBehaviour.Properties props) {
        DeferredBlock<T> registered = ModBlocksRegister.registerBlock(path, factory, props);
        ModRegistries.ITEMS.registerSimpleBlockItem(registered);
        return registered;
    }

    @NotNull
    private static DeferredBlock<FluidPipe> registerPipe(@NotNull String path, @NotNull FluidBlockSettings modSettings, @NotNull BlockBehaviour.Properties props) {
        return ModBlocksRegister.registerBlockAndItem(path, props1 -> new FluidPipe((BlockBehaviour.Properties)props1, modSettings), props);
    }

    @NotNull
    public static DeferredBlock<FluidFitting> registerFitting(String path, FluidBlockSettings modSettings, BlockBehaviour.Properties props) {
        return ModBlocksRegister.registerBlockAndItem(path, props1 -> new FluidFitting((BlockBehaviour.Properties)props1, modSettings), props);
    }

    @NotNull
    public static DeferredBlock<FluidPipe> registerWoodenPipe(@NotNull String path, @NotNull MapColor mapColor, float hardness, float resistance, @NotNull FluidBlockSettings modProperties) {
        return ModBlocksRegister.registerPipe(path, modProperties, BlockBehaviour.Properties.of().mapColor(mapColor).requiresCorrectToolForDrops().strength(hardness, resistance).sound(SoundType.WOOD).ignitedByLava());
    }

    @NotNull
    public static DeferredBlock<FluidPipe> registerStonePipe(@NotNull String path, @NotNull MapColor mapColor, float hardness, float resistance, @NotNull FluidBlockSettings modProperties) {
        return ModBlocksRegister.registerPipe(path, modProperties, BlockBehaviour.Properties.of().mapColor(mapColor).requiresCorrectToolForDrops().strength(hardness, resistance).sound(SoundType.STONE));
    }

    @NotNull
    public static DeferredBlock<FluidFitting> registerWoodenFitting(@NotNull String path, @NotNull MapColor mapColor, float hardness, float resistance, @NotNull FluidBlockSettings modProperties) {
        return ModBlocksRegister.registerFitting(path, modProperties, BlockBehaviour.Properties.of().mapColor(mapColor).requiresCorrectToolForDrops().strength(hardness, resistance).sound(SoundType.WOOD).ignitedByLava());
    }

    @NotNull
    public static DeferredBlock<FluidFitting> registerStoneFitting(@NotNull String path, @NotNull MapColor mapColor, float hardness, float resistance, @NotNull FluidBlockSettings modProperties) {
        return ModBlocksRegister.registerFitting(path, modProperties, BlockBehaviour.Properties.of().mapColor(mapColor).requiresCorrectToolForDrops().strength(hardness, resistance).sound(SoundType.STONE));
    }
}

