/*
 * Decompiled with CFR 0.152.
 */
package net.ttzplayz.create_wizardry.fluids;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.ttzplayz.create_wizardry.item.CWItems;

public class CWFluidRegistry {
    private static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"create_wizardry");
    private static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"create_wizardry");
    public static final DeferredHolder<FluidType, FluidType> MANA_TYPE = FLUID_TYPES.register("mana_type", () -> new FluidType(FluidType.Properties.create().rarity(Rarity.RARE).viscosity(200).canConvertToSource(false).lightLevel(15)));
    public static final DeferredHolder<FluidType, FluidType> LIGHTNING_TYPE = FLUID_TYPES.register("lightning_type", () -> new FluidType(FluidType.Properties.create().rarity(Rarity.RARE).viscosity(200).temperature(3000).pathType(PathType.BLOCKED).canConvertToSource(false).lightLevel(15)));
    public static final DeferredHolder<Fluid, FlowingFluid> MANA = FLUIDS.register("mana", () -> new BaseFlowingFluid.Source(MANA_PROPERTIES));
    public static final DeferredHolder<Fluid, FlowingFluid> MANA_FLOWING = FLUIDS.register("mana_flowing", () -> new BaseFlowingFluid.Flowing(MANA_PROPERTIES));
    private static final BaseFlowingFluid.Properties MANA_PROPERTIES = new BaseFlowingFluid.Properties(MANA_TYPE, MANA, MANA_FLOWING).explosionResistance(100.0f).bucket(CWItems.MANA_BUCKET).levelDecreasePerBlock(1).tickRate(20);
    public static final DeferredHolder<Fluid, FlowingFluid> LIGHTNING = FLUIDS.register("lightning", () -> new BaseFlowingFluid.Source(LIGHTNING_PROPERTIES));
    public static final DeferredHolder<Fluid, FlowingFluid> LIGHTNING_FLOWING = FLUIDS.register("lightning_flowing", () -> new BaseFlowingFluid.Flowing(LIGHTNING_PROPERTIES));
    private static final BaseFlowingFluid.Properties LIGHTNING_PROPERTIES = new BaseFlowingFluid.Properties(LIGHTNING_TYPE, LIGHTNING, LIGHTNING_FLOWING).explosionResistance(100.0f).bucket(CWItems.LIGHTNING_BUCKET).levelDecreasePerBlock(1).tickRate(20);

    public static void register(IEventBus eventBus) {
        FLUIDS.register(eventBus);
        FLUID_TYPES.register(eventBus);
    }
}

