/*
 * Decompiled with CFR 0.152.
 */
package net.ttzplayz.create_wizardry.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import net.ttzplayz.create_wizardry.datagen.CWBlockTagProvider;
import net.ttzplayz.create_wizardry.datagen.CWItemModelProvider;
import net.ttzplayz.create_wizardry.datagen.CWItemTagProvider;
import net.ttzplayz.create_wizardry.datagen.CWRecipeProvider;

@EventBusSubscriber(modid="create_wizardry", bus=EventBusSubscriber.Bus.MOD)
public class CWDataGenerators {
    public CWDataGenerators(IEventBus modBus) {
        if (!DatagenModLoader.isRunningDataGen()) {
            return;
        }
        modBus.register((Object)this);
    }

    @SubscribeEvent
    public static void generate(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PackOutput output = generator.getPackOutput();
        event.includeClient();
        boolean server = event.includeServer();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(server, (DataProvider)new CWRecipeProvider(output, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new CWItemModelProvider(packOutput, existingFileHelper));
        CWBlockTagProvider blockTagsProvider = new CWBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new CWItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
    }
}

