/*
 * Decompiled with CFR 0.152.
 */
package net.ttzplayz.create_wizardry;

import com.mojang.logging.LogUtils;
import io.redspace.ironsspellbooks.fluids.SimpleClientFluidType;
import io.redspace.ironsspellbooks.registries.CreativeTabRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.ttzplayz.create_wizardry.Config;
import net.ttzplayz.create_wizardry.block.CWBlocks;
import net.ttzplayz.create_wizardry.block.entity.ModBlockEntities;
import net.ttzplayz.create_wizardry.fluids.CWFluidRegistry;
import net.ttzplayz.create_wizardry.item.CWItems;
import org.slf4j.Logger;

@Mod(value="create_wizardry")
public class CreateWizardry {
    public static final String MOD_ID = "create_wizardry";
    private static final Logger LOGGER = LogUtils.getLogger();

    public CreateWizardry(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        CWFluidRegistry.register(modEventBus);
        CWBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        CWItems.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeTabRegistry.MATERIALS_TAB.getKey()) {
            event.insertAfter(((Item)ItemRegistry.RAW_MITHRIL.get()).getDefaultInstance(), ((Item)CWItems.CRUSHED_MITHRIL.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(((Item)ItemRegistry.MITHRIL_SCRAP.get()).getDefaultInstance(), ((Item)CWItems.MITHRIL_NUGGET.get()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)CWItems.MANA_BUCKET.get());
            event.accept((ItemLike)CWItems.LIGHTNING_BUCKET.get());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    @EventBusSubscriber(modid="create_wizardry", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }

        @SubscribeEvent
        public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
            event.registerFluidType((IClientFluidTypeExtensions)new SimpleClientFluidType(CreateWizardry.id("block/mana")), new Holder[]{CWFluidRegistry.MANA_TYPE});
            event.registerFluidType((IClientFluidTypeExtensions)new SimpleClientFluidType(CreateWizardry.id("block/lightning")), new Holder[]{CWFluidRegistry.LIGHTNING_TYPE});
        }
    }
}

