/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.westerngorilla.mob.goals;

import aquariusplayz.animalgarden.westerngorilla.mob.ModMob;
import java.util.EnumSet;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class ModPanicGoal
extends Goal {
    public static final int WATER_CHECK_DISTANCE_VERTICAL = 1;
    protected final ModMob mob;
    protected final double speedModifier;
    protected double posX;
    protected double posY;
    protected double posZ;
    protected boolean isRunning;
    private final Function<PathfinderMob, TagKey<DamageType>> panicCausingDamageTypes;

    public ModPanicGoal(ModMob p_25691_, double p_25692_) {
        this(p_25691_, p_25692_, (TagKey<DamageType>)DamageTypeTags.PANIC_CAUSES);
    }

    public ModPanicGoal(ModMob p_344360_, double p_345088_, TagKey<DamageType> p_345524_) {
        this(p_344360_, p_345088_, (PathfinderMob p_341380_) -> p_345524_);
    }

    public ModPanicGoal(ModMob p_343339_, double p_343298_, Function<PathfinderMob, TagKey<DamageType>> p_344730_) {
        this.mob = p_343339_;
        this.speedModifier = p_343298_;
        this.panicCausingDamageTypes = p_344730_;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        BlockPos blockpos;
        if (this.mob.getBehaviorType() == 4 || this.mob.isTame()) {
            return false;
        }
        if (!this.shouldPanic()) {
            return false;
        }
        if (this.mob.isOnFire() && (blockpos = this.lookForWater((BlockGetter)this.mob.level(), (Entity)this.mob, 5)) != null) {
            this.posX = blockpos.getX();
            this.posY = blockpos.getY();
            this.posZ = blockpos.getZ();
            return true;
        }
        return this.findRandomPosition();
    }

    public void tick() {
        if (!this.mob.unableToMoveToOwner() && this.mob.shouldTryTeleportToOwner()) {
            this.mob.tryToTeleportToOwner();
        }
        super.tick();
    }

    protected boolean shouldPanic() {
        return this.mob.getLastDamageSource() != null && this.mob.getLastDamageSource().is(this.panicCausingDamageTypes.apply((PathfinderMob)this.mob));
    }

    protected boolean findRandomPosition() {
        Vec3 vec3 = DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)5, (int)4);
        if (vec3 == null) {
            return false;
        }
        this.posX = vec3.x;
        this.posY = vec3.y;
        this.posZ = vec3.z;
        return true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.posX, this.posY, this.posZ, this.speedModifier);
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
    }

    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone();
    }

    protected BlockPos lookForWater(BlockGetter p_198173_, Entity p_198174_, int p_198175_) {
        BlockPos blockpos = p_198174_.blockPosition();
        return !p_198173_.getBlockState(blockpos).getCollisionShape(p_198173_, blockpos).isEmpty() ? null : (BlockPos)BlockPos.findClosestMatch((BlockPos)p_198174_.blockPosition(), (int)p_198175_, (int)1, p_196649_ -> p_198173_.getFluidState(p_196649_).is(FluidTags.WATER)).orElse(null);
    }
}

