/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.westerngorilla.mob;

import aquariusplayz.animalgarden.westerngorilla.config.ModConfigs;
import aquariusplayz.animalgarden.westerngorilla.mob.ModAnimationState;
import aquariusplayz.animalgarden.westerngorilla.mob.controls.ModBodyRotationControl;
import aquariusplayz.animalgarden.westerngorilla.mob.goals.ModBreedGoal;
import aquariusplayz.animalgarden.westerngorilla.mob.goals.ModFollowMaleGoal;
import aquariusplayz.animalgarden.westerngorilla.mob.goals.ModFollowParentGoal;
import aquariusplayz.animalgarden.westerngorilla.mob.goals.ModLeapAtTargetGoal;
import aquariusplayz.animalgarden.westerngorilla.mob.goals.ModMeleeAttackGoal;
import aquariusplayz.animalgarden.westerngorilla.mob.goals.ModNearestAttackableTargetGoal;
import aquariusplayz.animalgarden.westerngorilla.mob.goals.ModOwnerHurtByTargetGoal;
import aquariusplayz.animalgarden.westerngorilla.mob.goals.ModOwnerHurtTargetGoal;
import aquariusplayz.animalgarden.westerngorilla.mob.goals.ModWaterAvoidingRandomStrollGoal;
import aquariusplayz.animalgarden.westerngorilla.setup.Registrations;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ModMob
extends TamableAnimal
implements NeutralMob {
    public static final Predicate<ItemEntity> ALLOWED_ENTITIES = entity -> entity.isAlive() && entity.getItem() != null;
    public static final double FOLLOW_LEADER_START_DISTANCE = 30.0;
    private static final EntityDataAccessor<Boolean> CAN_SLEEP = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> WAS_FEED = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BEHAVIOR = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FUR_COLOR = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private UUID persistentAngerTarget;
    public ModAnimationState wink = new ModAnimationState();
    public ModAnimationState eyeLookLeft = new ModAnimationState();
    public ModAnimationState eyeLookRight = new ModAnimationState();
    public ModAnimationState eyeLookUp = new ModAnimationState();
    public ModAnimationState eyeLookDown = new ModAnimationState();
    public ModAnimationState eyeBrow1 = new ModAnimationState();
    public ModAnimationState eyeBrow2 = new ModAnimationState();
    public ModAnimationState eyeBrowUp = new ModAnimationState();
    public ModAnimationState eyeBrowDown = new ModAnimationState();
    public ModAnimationState breathing = new ModAnimationState();
    public ModAnimationState sniffing = new ModAnimationState();
    public ModAnimationState eat = new ModAnimationState();
    public ModAnimationState makeSound1 = new ModAnimationState();
    public ModAnimationState headLookLeft = new ModAnimationState();
    public ModAnimationState headLookRight = new ModAnimationState();
    public ModAnimationState headLookUp = new ModAnimationState();
    public ModAnimationState headLookDown = new ModAnimationState();
    public ModAnimationState headTiltLeft = new ModAnimationState();
    public ModAnimationState headTiltRight = new ModAnimationState();
    public ModAnimationState bite = new ModAnimationState();
    public ModAnimationState punch = new ModAnimationState();
    public ModAnimationState fromNormalToSitting = new ModAnimationState();
    public ModAnimationState sittingLoop = new ModAnimationState();
    public ModAnimationState fromSittingToNormal = new ModAnimationState();
    public ModAnimationState chestPump = new ModAnimationState();
    public ItemEntity itemEntityTarget = null;
    public BlockPos wanderAroundBlockPosWhenTamedAndPlayerIsNotNear;
    private int lastIdleSoundTick;
    public int leapCooldown;
    public float climbingXRotation;
    public LivingEntity futureTarget;
    private int isCalmTick;
    private int noActionTick;
    private int blockThrowningCooldown;
    private int eatTick;
    public static int maxNextInt = 6000;
    public int randomItemTick = this.random.nextInt(maxNextInt) + maxNextInt;
    private int attackCooldown;
    private int chestPumpTick;

    public static boolean checkModMobSpawnRules(EntityType<? extends Mob> p_217058_, ServerLevelAccessor p_217059_, MobSpawnType p_362165_, BlockPos p_217061_, RandomSource p_217062_) {
        int spawnChance = 100 / (ModConfigs.WEIGHT + 1);
        if (p_217062_.nextInt(Math.max(1, spawnChance)) != 0) {
            return false;
        }
        List list = p_217059_.getLevel().getEntitiesOfClass(ModMob.class, new AABB(p_217061_).inflate((double)ModConfigs.checkAreaSizeForMobsOfSameTypeWhenSpawning));
        int mobsFound = 0;
        for (ModMob entity : list) {
            if (!entity.isAlive()) continue;
            ++mobsFound;
        }
        if (mobsFound >= ModConfigs.maxMobOfSameTypeAroundAreaWhenSpawning) {
            return false;
        }
        BlockPos blockpos = p_217061_.below();
        return MobSpawnType.isSpawner((MobSpawnType)p_362165_) || p_217059_.getBlockState(blockpos).isValidSpawn((BlockGetter)p_217059_, blockpos, p_217058_);
    }

    public ModMob(EntityType<? extends ModMob> p_29362_, Level p_29363_) {
        super(p_29362_, p_29363_);
        this.setTame(false, false);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    protected int calculateFallDamage(float p_393496_, float p_21237_) {
        return 0;
    }

    public boolean causeFallDamage(float p_393354_, float p_147187_, DamageSource p_147189_) {
        return false;
    }

    protected void checkFallDamage(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new ModBreedGoal(this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new ModLeapAtTargetGoal(this, 0.7f));
        this.goalSelector.addGoal(3, (Goal)new ModMeleeAttackGoal(this, 1.0, true));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(5, (Goal)new ModFollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new ModFollowMaleGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new ModWaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.targetSelector.addGoal(1, (Goal)new ModOwnerHurtByTargetGoal(this));
        this.targetSelector.addGoal(2, (Goal)new ModOwnerHurtTargetGoal(this));
        this.targetSelector.addGoal(4, new ModNearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, true, false, arg_0 -> ((ModMob)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(5, new ModNearestAttackableTargetGoal<ModMob>((Mob)this, ModMob.class, 10, true, false, this::fightMale));
        this.targetSelector.addGoal(6, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    private boolean fightMale(LivingEntity p_21675_) {
        if (p_21675_ instanceof ModMob) {
            ModMob mob = (ModMob)p_21675_;
            if (this.getGender() == 0 && !this.isTame() && mob.getGender() == 0 && this.getRandom().nextInt(500) == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean wantsToAttack(LivingEntity enemy, LivingEntity owner) {
        TamableAnimal tamableanimal;
        AbstractHorse abstracthorse;
        if (enemy instanceof Creeper || enemy instanceof Ghast || enemy instanceof ArmorStand) {
            return false;
        }
        if (enemy instanceof ModMob) {
            ModMob mob = (ModMob)enemy;
            return !mob.isTame() || mob.getOwner() != owner;
        }
        if (enemy instanceof Player && this.isTame() && this.getOwner() == enemy) {
            return false;
        }
        if (enemy instanceof Player) {
            Player player1;
            Player player = (Player)enemy;
            if (owner instanceof Player && !(player1 = (Player)owner).canHarmPlayer(player)) {
                return false;
            }
        }
        if (enemy instanceof AbstractHorse && (abstracthorse = (AbstractHorse)enemy).isTamed()) {
            return false;
        }
        return !(enemy instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)enemy).isTame();
    }

    private void behaviorOnServerSide() {
        ImmutableList items;
        if (this.lastIdleSoundTick > 0) {
            --this.lastIdleSoundTick;
        }
        if (this.getMainHandItem() != null && !this.isBaby() && this.isAlive() && this.getMainHandItem().isEmpty() && --this.randomItemTick <= 0 && (items = ImmutableList.copyOf((Iterable)BuiltInRegistries.ITEM.getTagOrEmpty(Registrations.RANDOM_ITEM))) != null && items.size() > 0) {
            ItemStack randomItem = new ItemStack((Holder)items.get(this.getRandom().nextInt(items.size())));
            this.setItemSlotAndDropWhenKilled(EquipmentSlot.MAINHAND, randomItem);
            this.playSound(SoundEvents.ITEM_PICKUP, this.getSoundVolume(), this.getVoicePitch());
            this.randomItemTick = this.random.nextInt(maxNextInt) + maxNextInt;
        }
        if (this.getRandom().nextInt(200) == 0 && this.lastIdleSoundTick <= 0 && !this.isPassenger() && this.level().getNearestPlayer((Entity)this, (double)ModConfigs.playSoundDistance) != null) {
            this.playSound((SoundEvent)Registrations.IDLE.get(), this.getSoundVolume(), this.getVoicePitch());
            this.level().broadcastEntityEvent((Entity)this, (byte)8);
            this.lastIdleSoundTick = 20 * (this.getRandom().nextInt(20) + 10);
        }
        if (this.getNavigation().isDone() && !this.walkAnimation.isMoving() && this.getBehaviorType() == 0 && this.getTarget() == null && this.itemEntityTarget == null && this.getRandom().nextInt(800) == 0) {
            this.setBehaviorType(4);
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.25, 0.25, 0.25));
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        } else if (this.getBehaviorType() == 4 && this.getRandom().nextInt(1000) == 0) {
            this.setBehaviorType(0);
            this.level().broadcastEntityEvent((Entity)this, (byte)5);
        }
        if (this.blockThrowningCooldown > 0) {
            --this.blockThrowningCooldown;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.tickCount % 200 == 0 && this.getTarget() == null) {
            if (this.getBehaviorType() == 4 && this.getHealth() < this.getMaxHealth()) {
                this.heal(1.0f);
            } else if (this.futureTarget == null && !this.isTame() && this.getGender() == 0) {
                List list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(12.0, 4.0, 12.0), entity -> entity.isAlive() && !(entity instanceof ModMob) && !(entity instanceof AbstractFish) && !entity.isCrouching());
                LivingEntity targetLivingEntity = null;
                double d0 = Double.MAX_VALUE;
                for (LivingEntity targetFromList : list) {
                    Mob mob;
                    double speed = Math.abs(targetFromList.getDeltaMovement().x) + Math.abs(targetFromList.getDeltaMovement().z);
                    if (targetFromList instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)targetFromList;
                        if (player.isCreative() || player.isSpectator()) continue;
                        double d = speed = Math.abs(player.getDeltaMovement().x) + Math.abs(player.getDeltaMovement().y) > 0.0 ? 1.0 : 0.0;
                    }
                    if (targetFromList instanceof Mob && ((mob = (Mob)targetFromList).isAggressive() || mob.getTarget() != null)) {
                        speed = 1.0;
                    }
                    double d1 = this.distanceToSqr((Entity)targetFromList);
                    if (speed < 0.01 || d1 > d0) continue;
                    d0 = d1;
                    targetLivingEntity = targetFromList;
                }
                this.futureTarget = targetLivingEntity;
                this.isCalmTick = 0;
            }
        }
        if (this.futureTarget != null) {
            ServerPlayer player;
            Mob mob;
            double speed = Math.abs(this.futureTarget.getDeltaMovement().x) + Math.abs(this.futureTarget.getDeltaMovement().z);
            LivingEntity livingEntity = this.futureTarget;
            if (livingEntity instanceof Mob && ((mob = (Mob)livingEntity).isAggressive() || mob.getTarget() != null)) {
                speed = 1.0;
            }
            if ((livingEntity = this.futureTarget) instanceof ServerPlayer && !(player = (ServerPlayer)livingEntity).isCreative() && !player.isSpectator()) {
                double d = speed = Math.abs(player.getDeltaMovement().x) + Math.abs(player.getDeltaMovement().y) > 0.0 ? 1.0 : 0.0;
            }
            if (this.distanceToSqr((Entity)this.futureTarget) > 400.0 || !this.futureTarget.isAlive() || this.isTame()) {
                this.futureTarget = null;
                this.isCalmTick = 0;
                this.setTarget(null);
            } else if (this.futureTarget.isAlive() && !this.futureTarget.isCrouching() && this.distanceToSqr((Entity)this.futureTarget) <= 400.0) {
                if (speed > (double)0.01f) {
                    ++this.isCalmTick;
                }
                if (this.isCalmTick > 100) {
                    this.setTarget(this.futureTarget);
                    this.noActionTick = 0;
                    if (this.distanceToSqr((Entity)this.futureTarget) > 50.0 && this.blockThrowningCooldown == 0) {
                        this.blockThrowningCooldown = 100;
                        this.getLookControl().setLookAt(this.futureTarget.getLookAngle());
                        BlockPos pos = this.blockPosition().below();
                        BlockState state = this.level().getBlockState(pos);
                        if (!ModMob.isFree(this.level().getBlockState(pos)) && pos.getY() >= this.level().getMinBuildHeight()) {
                            FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)this.level(), (BlockPos)pos, (BlockState)state);
                            fallingblockentity.setPos((double)pos.above().getX(), (double)pos.above().getY(), (double)pos.above().getZ());
                            fallingblockentity.setDeltaMovement(this.getViewVector(1.0f).add(0.0, 0.4, 0.0));
                            fallingblockentity.xo = pos.above().getX();
                            fallingblockentity.yo = pos.above().getY();
                            fallingblockentity.zo = pos.above().getZ();
                            fallingblockentity.setStartPos(pos.above());
                            fallingblockentity.setHurtsEntities(1.0f, 4);
                            fallingblockentity.hurtMarked = true;
                            this.level().broadcastEntityEvent((Entity)this, (byte)18);
                            this.playSound(SoundEvents.GENERIC_BIG_FALL, this.getSoundVolume(), this.getVoicePitch() * 0.5f);
                        }
                    }
                    if (this.getAttackBoundingBox().inflate(0.5).intersects(this.futureTarget.getBoundingBox())) {
                        if (this.canPerformAttack(this.futureTarget)) {
                            this.attackCooldown = 20;
                            this.getLookControl().setLookAt((Entity)this.futureTarget);
                            this.swing(InteractionHand.MAIN_HAND);
                            this.doHurtTarget((Entity)this.futureTarget);
                        }
                    } else {
                        this.getLookControl().setLookAt((Entity)this.futureTarget);
                        this.getNavigation().moveTo(this.futureTarget.getX(), this.futureTarget.getY(), this.futureTarget.getZ(), 1.0);
                    }
                } else if (this.getAttackBoundingBox().inflate(3.0).intersects(this.futureTarget.getBoundingBox())) {
                    this.getLookControl().setLookAt(this.futureTarget.getViewVector(1.0f));
                    this.noActionTick = 200;
                } else if (this.noActionTick == 0) {
                    this.getLookControl().setLookAt((Entity)this.futureTarget);
                    this.getNavigation().moveTo(this.futureTarget.getX(), this.futureTarget.getY(), this.futureTarget.getZ(), 1.25);
                }
            }
        }
    }

    protected boolean canPerformAttack(LivingEntity p_301160_) {
        return this.attackCooldown == 0 && this.isWithinMeleeAttackRange(p_301160_) && this.getSensing().hasLineOfSight((Entity)p_301160_);
    }

    public static boolean isFree(BlockState p_53242_) {
        return p_53242_.isAir() || p_53242_.is(BlockTags.FIRE) || p_53242_.liquid() || p_53242_.canBeReplaced();
    }

    public void aiStep() {
        super.aiStep();
        Vec3 delta = this.getDeltaMovement();
        if (!this.onGround() && delta.y < 0.0) {
            this.setDeltaMovement(delta.multiply(1.0, 0.9, 1.0));
        }
        if (this.leapCooldown > 0) {
            --this.leapCooldown;
        }
        if (this.getTarget() != null && !this.onGround()) {
            this.getLookControl().setLookAt((Entity)this.getTarget());
        }
        if (this.tickCount % 200 == 0 && this.getTarget() == null) {
            List list;
            if (!(this.itemEntityTarget == null || this.itemEntityTarget.isAlive() && this.getMainHandItem().isEmpty())) {
                this.itemEntityTarget = null;
            }
            if (this.itemEntityTarget == null && this.getMainHandItem().isEmpty() && this.getBehaviorType() != 4 && !(list = this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(8.0, 4.0, 8.0), ALLOWED_ENTITIES)).isEmpty()) {
                list.forEach(entity -> {
                    if (this.getSensing().hasLineOfSight((Entity)entity) && (entity.getItem().get(DataComponents.FOOD) != null || entity.getItem().is(Registrations.RANDOM_ITEM))) {
                        if (this.itemEntityTarget == null) {
                            this.itemEntityTarget = entity;
                        } else if (this.distanceToSqr((Entity)entity) < this.distanceToSqr((Entity)this.itemEntityTarget)) {
                            this.itemEntityTarget = entity;
                        }
                    }
                });
            }
        }
        if (this.itemEntityTarget != null && this.getTarget() == null && this.getBehaviorType() != 4) {
            if (!this.itemEntityTarget.isAlive()) {
                this.itemEntityTarget = null;
            } else {
                this.getLookControl().setLookAt((Entity)this.itemEntityTarget, (float)(this.getMaxHeadYRot() + 20), (float)this.getMaxHeadXRot());
                if (this.leapCooldown == 0 && this.getAttackBoundingBox().inflate(3.0).intersects(this.itemEntityTarget.getBoundingBox())) {
                    Vec3 vec3 = this.getDeltaMovement();
                    Vec3 vec31 = new Vec3(this.itemEntityTarget.getX() - this.getX(), 0.0, this.itemEntityTarget.getZ() - this.getZ());
                    if (vec31.lengthSqr() > 1.0E-7) {
                        vec31 = vec31.normalize().scale(0.65).add(vec3.scale(0.2));
                    }
                    this.setDeltaMovement(vec31.x, 0.25, vec31.z);
                    this.leapCooldown = 100;
                }
                if (this.getAttackBoundingBox().inflate(0.1).intersects(this.itemEntityTarget.getBoundingBox())) {
                    Level level = this.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel level2 = (ServerLevel)level;
                        level2.broadcastEntityEvent((Entity)this, (byte)18);
                        if (this.itemEntityTarget.getItem().get(DataComponents.FOOD) != null || this.itemEntityTarget.getItem().is(Registrations.RANDOM_ITEM)) {
                            this.setItemSlotAndDropWhenKilled(EquipmentSlot.MAINHAND, this.itemEntityTarget.getItem().copy());
                            this.playSound(SoundEvents.ITEM_PICKUP, this.getSoundVolume(), this.getVoicePitch());
                            this.itemEntityTarget.discard();
                        }
                    }
                    this.itemEntityTarget = null;
                    this.getNavigation().stop();
                } else {
                    this.getNavigation().moveTo(this.itemEntityTarget.getX(), this.itemEntityTarget.getY(), this.itemEntityTarget.getZ(), 1.25);
                }
            }
        }
        if (this.eatTick > 0) {
            --this.eatTick;
            if (this.eatTick == 0) {
                this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            }
        }
        if (!this.getMainHandItem().isEmpty() && this.getTarget() == null && (this.getMainHandItem().get(DataComponents.FOOD) != null || this.getMainHandItem().is(Registrations.RANDOM_ITEM)) && this.getHealth() < this.getMaxHealth() && this.eatTick == 0) {
            this.eatTick = 60;
            this.heal(10.0f);
            this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), 1.0f);
            this.level().broadcastEntityEvent((Entity)this, (byte)10);
        }
        if (this.getBehaviorType() == 4 && (double)this.walkAnimation.speed() > 0.2) {
            this.setBehaviorType(0);
        }
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
            this.behaviorOnServerSide();
        } else {
            if (this.getBehaviorType() == 4) {
                if (!(this.sittingLoop.isStarted() || this.fromNormalToSitting.isStarted() || this.fromSittingToNormal.isStarted())) {
                    this.fromNormalToSitting.start(this.tickCount);
                } else if (this.fromNormalToSitting.isStarted() && this.animationEnded(this.fromNormalToSitting, 0.5f)) {
                    this.fromNormalToSitting.stop();
                    this.sittingLoop.start(this.tickCount);
                } else if (this.fromSittingToNormal.isStarted() && this.animationEnded(this.fromSittingToNormal, 0.5f)) {
                    this.fromSittingToNormal.stop();
                    this.fromNormalToSitting.start(this.tickCount);
                } else {
                    this.defaultAnimations();
                }
            } else if (this.sittingLoop.isStarted()) {
                this.sittingLoop.stop();
                this.fromSittingToNormal.start(this.tickCount);
            } else if (this.fromNormalToSitting.isStarted() && this.animationEnded(this.fromNormalToSitting, 0.5f)) {
                this.fromNormalToSitting.stop();
                this.fromSittingToNormal.start(this.tickCount);
            } else if (this.fromSittingToNormal.isStarted() && this.animationEnded(this.fromSittingToNormal, 0.5f)) {
                this.fromSittingToNormal.stop();
            } else if (!this.isAggressive()) {
                this.defaultAnimations();
            }
            if (!this.breathing.isStarted()) {
                this.breathing.start(this.tickCount);
            }
        }
    }

    protected float getJumpPower() {
        return this.getJumpPower(1.25f);
    }

    private void defaultAnimations() {
        Level level = this.level();
        if (level.random.nextInt(100) == 0 && this.animationEnded(this.wink, 1.0f)) {
            this.wink.start(this.tickCount);
        }
        if (level.random.nextInt(100) == 0 && this.animationEnded(this.sniffing, 1.0f)) {
            this.sniffing.start(this.tickCount);
        }
        if (level.random.nextInt(this.getGender() == 0 ? 300 : 1000) == 0 && this.getBehaviorType() != 4 && this.walkAnimation.speed() < 0.2f && this.animationEnded(this.chestPump, 3.0f) && this.animationEnded(this.eat, 3.25f) && this.animationEnded(this.punch, 3.0f)) {
            this.chestPump.start(this.tickCount);
            this.chestPumpTick = 20;
        }
        if (this.chestPumpTick > 0) {
            --this.chestPumpTick;
        }
        if (this.chestPumpTick == 5) {
            this.level().playLocalSound((Entity)this, (SoundEvent)Registrations.CHEST_PUMP.get(), this.getSoundSource(), this.getSoundVolume(), 1.0f);
        }
        if (level.random.nextInt(50) == 0 && this.animationEnded(this.eyeLookRight, 1.75f) && this.animationEnded(this.eyeLookLeft, 1.75f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.eyeLookRight.start(this.tickCount);
            } else {
                this.eyeLookLeft.start(this.tickCount);
            }
        }
        if (level.random.nextInt(50) == 0 && this.animationEnded(this.eyeLookUp, 1.75f) && this.animationEnded(this.eyeLookDown, 1.75f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.eyeLookUp.start(this.tickCount);
            } else {
                this.eyeLookDown.start(this.tickCount);
            }
        }
        if (level.random.nextInt(300) == 0 && this.animationEnded(this.eyeBrow1, 2.0f) && this.animationEnded(this.eyeBrow2, 2.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.eyeBrow1.start(this.tickCount);
            } else {
                this.eyeBrow2.start(this.tickCount);
            }
        }
        if (level.random.nextInt(200) == 0 && this.animationEnded(this.eyeBrowUp, 2.0f) && this.animationEnded(this.eyeBrowDown, 2.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.eyeBrowUp.start(this.tickCount);
            } else {
                this.eyeBrowDown.start(this.tickCount);
            }
        }
        if (level.random.nextInt(200) == 0 && this.animationEnded(this.headLookDown, 3.0f) && this.animationEnded(this.headLookUp, 3.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.headLookDown.start(this.tickCount);
            } else {
                this.headLookUp.start(this.tickCount);
            }
        }
        if (level.random.nextInt(200) == 0 && this.animationEnded(this.headLookLeft, 3.0f) && this.animationEnded(this.headLookRight, 3.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.headLookLeft.start(this.tickCount);
            } else {
                this.headLookRight.start(this.tickCount);
            }
        }
        if (level.random.nextInt(200) == 0 && this.animationEnded(this.headTiltLeft, 3.5f) && this.animationEnded(this.headTiltRight, 3.5f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.headTiltLeft.start(this.tickCount);
            } else {
                this.headTiltRight.start(this.tickCount);
            }
        }
    }

    protected BodyRotationControl createBodyControl() {
        return new ModBodyRotationControl((Mob)this);
    }

    public boolean animationEnded(ModAnimationState state, float animLength) {
        return (float)state.getTimeInMillis(this.tickCount) > animLength * 1000.0f;
    }

    public boolean doHurtTarget(Entity p_32257_) {
        if (this.getRandom().nextInt(2) == 0) {
            this.level().broadcastEntityEvent((Entity)this, (byte)18);
            this.playSound(SoundEvents.GENERIC_HURT, this.getSoundVolume(), this.getVoicePitch());
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)4);
            this.playSound(SoundEvents.FOX_BITE, this.getSoundVolume(), this.getVoicePitch() * 0.5f);
        }
        return super.doHurtTarget(p_32257_);
    }

    public boolean isWithinMeleeAttackRange(Entity p_217067_) {
        return this.getAttackBoundingBox().inflate(0.5).intersects(this.getHitbox(p_217067_));
    }

    protected AABB getHitbox(Entity p_217067_) {
        AABB aabb = p_217067_.getBoundingBox();
        Entity entity = p_217067_.getVehicle();
        if (entity != null) {
            Vec3 vec3 = entity.getPassengerRidingPosition(p_217067_);
            return aabb.setMinY(Math.max(vec3.y, aabb.minY));
        }
        return aabb;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_366700_, SpawnGroupData p_146749_) {
        this.setGender(this.getRandom().nextInt(5) == 0 ? 0 : 1);
        this.setFurColor(this.getRandom().nextInt(5));
        this.setStats();
        return super.finalizeSpawn(p_146746_, p_146747_, p_366700_, p_146749_);
    }

    protected void applyTamingSideEffects() {
        super.applyTamingSideEffects();
        this.setStats();
        this.setHealth(this.getMaxHealth());
    }

    public void setAge(int p_146763_) {
        super.setAge(p_146763_);
        this.setStats();
    }

    private void setStats() {
        if (this.getAge() < 0) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(10.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(1.0);
            this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(0.0);
            this.getAttribute(Attributes.ATTACK_KNOCKBACK).setBaseValue(0.0);
        } else if (this.getGender() == 1) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(25.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(4.0);
            this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(0.25);
            this.getAttribute(Attributes.ATTACK_KNOCKBACK).setBaseValue(0.5);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(45.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(6.0);
            this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(0.5);
            this.getAttribute(Attributes.ATTACK_KNOCKBACK).setBaseValue(2.0);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 25.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.FOLLOW_RANGE, 10.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    public boolean isPersistenceRequired() {
        if (ModConfigs.isAlwaysPersistent || this.wasFeed() || this.isTame() || this.hasCustomName()) {
            return true;
        }
        return super.isPersistenceRequired();
    }

    public boolean requiresCustomPersistence() {
        if (ModConfigs.isAlwaysPersistent || this.wasFeed() || this.isTame() || this.hasCustomName()) {
            return true;
        }
        return super.requiresCustomPersistence();
    }

    public boolean removeWhenFarAway(double p_27492_) {
        if (ModConfigs.isAlwaysPersistent || this.wasFeed() || this.isTame() || this.hasCustomName()) {
            return false;
        }
        return super.removeWhenFarAway(p_27492_);
    }

    public boolean isFood(ItemStack p_30440_) {
        return p_30440_ != null && (p_30440_.get(DataComponents.FOOD) != null || p_30440_.is(Registrations.RANDOM_ITEM));
    }

    protected float getSoundVolume() {
        return ModConfigs.soundVolume;
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(0.5);
    }

    public boolean hurt(DamageSource p_364880_, float p_366649_) {
        if (this.isInvulnerableTo(p_364880_) || p_364880_.is(DamageTypes.FALLING_BLOCK)) {
            return false;
        }
        if (this.getBehaviorType() == 4) {
            this.setBehaviorType(this.isTame() ? 6 : 0);
        }
        this.playSound((SoundEvent)Registrations.IDLE.get(), this.getSoundVolume(), this.getVoicePitch());
        this.level().broadcastEntityEvent((Entity)this, (byte)8);
        return super.hurt(p_364880_, p_366649_);
    }

    public double getFollowDistance() {
        return this.getAttributeValue(Attributes.FOLLOW_RANGE);
    }

    protected boolean canFlyToOwner() {
        return true;
    }

    public AgeableMob getBreedOffspring(ServerLevel p_148993_, AgeableMob p_148994_) {
        ModMob mob = (ModMob)this.getType().create((Level)p_148993_);
        if (this.isTame()) {
            mob.setOwnerUUID(this.getOwnerUUID());
            mob.setTame(true, true);
        }
        mob.setGender(this.getRandom().nextInt(5) == 0 ? 0 : 1);
        mob.setFurColor(this.getRandom().nextInt(5));
        return mob;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_335317_) {
        super.defineSynchedData(p_335317_);
        p_335317_.define(DATA_REMAINING_ANGER_TIME, (Object)0);
        p_335317_.define(BEHAVIOR, (Object)0);
        p_335317_.define(FUR_COLOR, (Object)0);
        p_335317_.define(WAS_FEED, (Object)false);
        p_335317_.define(CAN_SLEEP, (Object)true);
        p_335317_.define(GENDER, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag p_29422_) {
        super.addAdditionalSaveData(p_29422_);
        this.addPersistentAngerSaveData(p_29422_);
        p_29422_.putInt("BehaviorType", this.getBehaviorType());
        p_29422_.putInt("FurColor", this.getFurColor());
        p_29422_.putBoolean("WasFeed", this.wasFeed());
        p_29422_.putBoolean("CanSleep", this.canSleep());
        p_29422_.putInt("Gender", this.getGender());
        p_29422_.putInt("randomItemTick", this.randomItemTick);
    }

    public void readAdditionalSaveData(CompoundTag p_29402_) {
        super.readAdditionalSaveData(p_29402_);
        this.readPersistentAngerSaveData(this.level(), p_29402_);
        this.setBehaviorType(p_29402_.getInt("BehaviorType"));
        this.setFurColor(p_29402_.getInt("FurColor"));
        this.wasFeed(p_29402_.getBoolean("WasFeed"));
        this.canSleep(p_29402_.getBoolean("CanSleep"));
        this.setGender(p_29402_.getInt("Gender"));
        if (p_29402_.contains("randomItemTick")) {
            this.randomItemTick = p_29402_.getInt("randomItemTick");
        }
    }

    public int getGender() {
        return (Integer)this.entityData.get(GENDER);
    }

    private void setGender(int p_30398_) {
        this.entityData.set(GENDER, (Object)p_30398_);
    }

    public boolean canSleep() {
        return (Boolean)this.entityData.get(CAN_SLEEP);
    }

    public void canSleep(boolean p_30398_) {
        this.entityData.set(CAN_SLEEP, (Object)p_30398_);
    }

    public boolean wasFeed() {
        return (Boolean)this.entityData.get(WAS_FEED);
    }

    public void wasFeed(boolean p_30398_) {
        this.entityData.set(WAS_FEED, (Object)p_30398_);
    }

    public int getFurColor() {
        return (Integer)this.entityData.get(FUR_COLOR);
    }

    public void setFurColor(int p_30398_) {
        this.entityData.set(FUR_COLOR, (Object)p_30398_);
    }

    public int getBehaviorType() {
        return (Integer)this.entityData.get(BEHAVIOR);
    }

    public void setBehaviorType(int p_30398_) {
        this.entityData.set(BEHAVIOR, (Object)p_30398_);
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int p_30404_) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    public void tryToTame(Player p_336244_) {
        this.tame(p_336244_);
        this.setTarget(null);
        this.level().broadcastEntityEvent((Entity)this, (byte)7);
    }

    public InteractionResult mobInteract(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.getItemInHand(p_30413_);
        ItemStack itemstack1 = this.getItemInHand(InteractionHand.MAIN_HAND);
        if (this.isTame()) {
            if (this.isFood(itemstack)) {
                this.wasFeed(true);
                this.usePlayerItem(p_30412_, p_30413_, itemstack);
                if (this.level() instanceof ServerLevel) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)10);
                    if (this.getHealth() < this.getMaxHealth()) {
                        this.heal(10.0f);
                    }
                    this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), 1.0f);
                }
                return super.mobInteract(p_30412_, p_30413_);
            }
            if (!itemstack1.isEmpty() && p_30413_ == InteractionHand.MAIN_HAND && itemstack.isEmpty() && p_30412_ == this.getOwner()) {
                this.wasFeed(true);
                this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                this.level().playSound(p_30412_, (Entity)this, SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, this.getSoundVolume(), 1.0f);
                p_30412_.addItem(itemstack1);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.mobInteract(p_30412_, p_30413_);
            return interactionresult;
        }
        if (!this.level().isClientSide() && this.isFood(itemstack)) {
            this.wasFeed(true);
            itemstack.consume(1, (LivingEntity)p_30412_);
            this.tryToTame(p_30412_);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(p_30412_, p_30413_);
    }

    protected void dropEquipment() {
        super.dropEquipment();
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!itemstack.isEmpty() && !EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) {
            this.spawnAtLocation(itemstack);
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
    }

    public void handleEntityEvent(byte p_397414_) {
        if (p_397414_ == 4) {
            if (this.animationEnded(this.bite, 0.9f)) {
                this.bite.start(this.tickCount);
            }
        } else if (p_397414_ == 5) {
            this.setBehaviorType(0);
        } else if (p_397414_ == 6) {
            this.setBehaviorType(4);
        } else if (p_397414_ == 8) {
            if (this.animationEnded(this.makeSound1, 1.3f) && this.animationEnded(this.bite, 1.0f)) {
                this.makeSound1.start(this.tickCount);
            }
        } else if (p_397414_ == 10) {
            if (this.animationEnded(this.eat, 3.25f)) {
                this.eat.start(this.tickCount);
            }
        } else if (p_397414_ == 14) {
            this.setBehaviorType(6);
            if (this.animationEnded(this.makeSound1, 1.3f) && this.animationEnded(this.bite, 1.0f)) {
                this.makeSound1.start(this.tickCount);
            }
        } else if (p_397414_ == 18) {
            if (this.animationEnded(this.punch, 1.0f)) {
                this.punch.start(this.tickCount);
            }
        } else {
            super.handleEntityEvent(p_397414_);
        }
    }

    public boolean canSpawnSprintParticle() {
        return this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7 && this.walkAnimation.speed() > 0.5f && this.random.nextInt(5) == 0;
    }
}

