/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.westerngorilla.mob;

import aquariusplayz.animalgarden.westerngorilla.mob.MobAnimations;
import aquariusplayz.animalgarden.westerngorilla.mob.ModAnimationState;
import aquariusplayz.animalgarden.westerngorilla.mob.ModMob;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class ModMobModel<T extends ModMob>
extends EntityModel<T>
implements HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"animalgarden_westerngorilla", (String)"mob"), "main");
    public final ModelPart rootz;
    public final ModelPart head;
    public final ModelPart headTop;
    public final ModelPart eyebrow;
    public final ModelPart rightEye;
    public final ModelPart rightEyeball;
    public final ModelPart leftEye;
    public final ModelPart leftEyeball;
    public final ModelPart mouth;
    public final ModelPart nose;
    public final ModelPart bottomMouth;
    public final ModelPart rightEar;
    public final ModelPart leftEar;
    public final ModelPart body;
    public final ModelPart realbody;
    public final ModelPart rightLeg;
    public final ModelPart rightLeg2;
    public final ModelPart leftLeg;
    public final ModelPart leftLeg2;
    public final ModelPart rightArm;
    public final ModelPart rightArm2;
    public final ModelPart rightArm3;
    public final ModelPart leftArm;
    public final ModelPart leftArm2;
    public final ModelPart leftArm3;
    private final ModelPart root;
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public ModMobModel(ModelPart root) {
        this.root = root.getChild("root");
        this.rootz = this.root.getChild("rootz");
        this.head = this.rootz.getChild("head");
        this.headTop = this.head.getChild("headTop");
        this.eyebrow = this.head.getChild("eyebrow");
        this.rightEye = this.head.getChild("rightEye");
        this.rightEyeball = this.rightEye.getChild("rightEyeball");
        this.leftEye = this.head.getChild("leftEye");
        this.leftEyeball = this.leftEye.getChild("leftEyeball");
        this.mouth = this.head.getChild("mouth");
        this.nose = this.mouth.getChild("nose");
        this.bottomMouth = this.mouth.getChild("bottomMouth");
        this.rightEar = this.head.getChild("rightEar");
        this.leftEar = this.head.getChild("leftEar");
        this.body = this.rootz.getChild("body");
        this.realbody = this.body.getChild("realbody");
        this.rightLeg = this.body.getChild("rightLeg");
        this.rightLeg2 = this.rightLeg.getChild("rightLeg2");
        this.leftLeg = this.body.getChild("leftLeg");
        this.leftLeg2 = this.leftLeg.getChild("leftLeg2");
        this.rightArm = this.body.getChild("rightArm");
        this.rightArm2 = this.rightArm.getChild("rightArm2");
        this.rightArm3 = this.rightArm2.getChild("rightArm3");
        this.leftArm = this.body.getChild("leftArm");
        this.leftArm2 = this.leftArm.getChild("leftArm2");
        this.leftArm3 = this.leftArm2.getChild("leftArm3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition rootz = root.addOrReplaceChild("rootz", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)26.0f, (float)-3.0f));
        PartDefinition head = rootz.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 35).addBox(-4.0f, -8.0f, -5.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-18.0f, (float)1.0f));
        PartDefinition headTop = head.addOrReplaceChild("headTop", CubeListBuilder.create().texOffs(33, 35).addBox(-4.0f, -3.0f, -2.0f, 8.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.0f, (float)-1.0f));
        PartDefinition eyebrow = head.addOrReplaceChild("eyebrow", CubeListBuilder.create().texOffs(64, 25).addBox(-4.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)-5.0f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(37, 69).addBox(-1.0f, -1.5f, -0.51f, 2.0f, 2.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)-2.0f, (float)-2.75f, (float)-4.6f));
        PartDefinition rightEyeball = rightEye.addOrReplaceChild("rightEyeball", CubeListBuilder.create().texOffs(28, 69).addBox(-1.0f, -1.0f, -0.511f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.1f, (float)-0.5f, (float)-0.4f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(69, 59).addBox(-1.0f, -1.5f, -0.51f, 2.0f, 2.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)2.0f, (float)-2.75f, (float)-4.6f));
        PartDefinition leftEyeball = leftEye.addOrReplaceChild("leftEyeball", CubeListBuilder.create().texOffs(68, 62).addBox(-1.0f, -1.0f, -0.511f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)-0.1f, (float)-0.5f, (float)-0.4f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(66, 0).addBox(-2.5f, -2.0f, -2.5f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(83, 1).addBox(-2.0f, -1.2f, -2.25f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.1f)).texOffs(83, 1).addBox(1.0f, -1.2f, -2.25f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)0.0f, (float)0.1f, (float)-4.5f));
        PartDefinition nose = mouth.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(64, 30).addBox(-1.5f, -0.9f, -1.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(25, 53).addBox(-1.1f, -0.4f, -1.21f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.2f)).texOffs(66, 11).addBox(0.1f, -0.4f, -1.21f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)0.0f, (float)-2.1f, (float)-1.5f));
        PartDefinition bottomMouth = mouth.addOrReplaceChild("bottomMouth", CubeListBuilder.create().texOffs(43, 15).addBox(-2.5f, 1.0f, -4.0f, 5.0f, 1.0f, 2.0f, new CubeDeformation(-0.05f)).texOffs(83, 1).addBox(-1.5f, 0.3f, -3.8f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.15f)).texOffs(83, 1).addBox(0.5f, 0.3f, -3.8f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.15f)), PartPose.offset((float)0.0f, (float)-1.05f, (float)1.55f));
        PartDefinition rightEar = head.addOrReplaceChild("rightEar", CubeListBuilder.create().texOffs(66, 5).addBox(-1.5f, -1.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)-4.0f, (float)-3.5f, (float)-1.0f));
        PartDefinition leftEar = head.addOrReplaceChild("leftEar", CubeListBuilder.create().texOffs(19, 69).addBox(-0.5f, -1.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)4.0f, (float)-3.5f, (float)-1.0f));
        PartDefinition body = rootz.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition realbody = body.addOrReplaceChild("realbody", CubeListBuilder.create().texOffs(0, 19).addBox(-6.0f, 0.0f, -4.0f, 12.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-6.0f, 7.0f, -5.0f, 12.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-17.0f, (float)1.0f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = body.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(33, 45).addBox(-2.0f, -1.5f, -3.0f, 4.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)-6.5f, (float)9.0f));
        PartDefinition rightLeg2 = rightLeg.addOrReplaceChild("rightLeg2", CubeListBuilder.create().texOffs(0, 53).addBox(-2.5f, -1.0f, -5.5f, 5.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)5.5f, (float)0.5f));
        PartDefinition leftLeg = body.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(54, 45).addBox(-2.0f, -1.5f, -3.0f, 4.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)-6.5f, (float)9.0f));
        PartDefinition leftLeg2 = leftLeg.addOrReplaceChild("leftLeg2", CubeListBuilder.create().texOffs(25, 59).addBox(-2.5f, -1.0f, -5.5f, 5.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)5.5f, (float)0.5f));
        PartDefinition rightArm = body.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(50, 59).addBox(-3.0f, -2.0f, -2.5f, 4.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)-14.25f, (float)2.5f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm2 = rightArm.addOrReplaceChild("rightArm2", CubeListBuilder.create().texOffs(41, 19).addBox(-2.75f, 0.0f, -2.75f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)6.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm3 = rightArm2.addOrReplaceChild("rightArm3", CubeListBuilder.create().texOffs(62, 34).addBox(-2.0f, -0.75f, -1.5f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.25f, (float)-1.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = body.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(0, 63).addBox(-1.0f, -2.0f, -2.5f, 4.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)-14.25f, (float)2.5f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm2 = leftArm.addOrReplaceChild("leftArm2", CubeListBuilder.create().texOffs(43, 0).addBox(-2.75f, 0.0f, -2.75f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)6.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm3 = leftArm2.addOrReplaceChild("leftArm3", CubeListBuilder.create().texOffs(64, 15).addBox(-2.0f, -0.75f, -1.5f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)7.25f, (float)-1.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T mob, float pos, float speed, float ageInTicks, float p_102622_, float p_102623_) {
        this.rootz.getAllParts().forEach(ModelPart::resetPose);
        this.headTop.visible = ((ModMob)((Object)mob)).getGender() == 0 && mob.getAge() > 0;
        this.animate(((ModMob)((Object)mob)).wink, MobAnimations.wink, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).sniffing, MobAnimations.sniffing, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).eyeLookLeft, MobAnimations.eyeLookLeft, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).eyeLookRight, MobAnimations.eyeLookRight, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).eyeLookUp, MobAnimations.eyeLookUp, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).eyeLookDown, MobAnimations.eyeLookDown, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).eyeBrow1, MobAnimations.eyeBrow1, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).eyeBrow2, MobAnimations.eyeBrow2, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).eyeBrowUp, MobAnimations.eyeBrowUp, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).eyeBrowDown, MobAnimations.eyeBrowDown, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).eat, MobAnimations.eat, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).makeSound1, MobAnimations.makeSound1, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).headLookLeft, MobAnimations.headLookLeft, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).headLookRight, MobAnimations.headLookRight, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).headLookUp, MobAnimations.headLookUp, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).headLookDown, MobAnimations.headLookDown, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).headTiltLeft, MobAnimations.headTiltLeft, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).headTiltRight, MobAnimations.headTiltRight, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).bite, MobAnimations.bite, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).punch, MobAnimations.punch, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).fromNormalToSitting, MobAnimations.fromNormalToSitting, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).sittingLoop, MobAnimations.sittingLoop, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).fromSittingToNormal, MobAnimations.fromSittingToNormal, ageInTicks, 1.0f);
        this.animate(((ModMob)((Object)mob)).chestPump, MobAnimations.chestPump, ageInTicks, 1.0f);
        this.animateWalk(MobAnimations.walk, pos, speed, mob.getAge() < 0 ? 2.5f : 5.0f, 10.0f);
    }

    public final ModelPart root() {
        return this.root;
    }

    protected void animate(ModAnimationState p_361867_, AnimationDefinition p_365477_, float p_361961_) {
        this.animate(p_361867_, p_365477_, p_361961_, 1.0f);
    }

    protected void animateWalk(AnimationDefinition p_363127_, float p_364817_, float p_364163_, float p_365350_, float p_365167_) {
        long i = (long)(p_364817_ * 50.0f * p_365350_);
        float f = Math.min(p_364163_ * p_365167_, 1.0f);
        ModMobModel.animate(this, p_363127_, i, f, ANIMATION_VECTOR_CACHE);
    }

    protected void animate(ModAnimationState p_368871_, AnimationDefinition p_365491_, float p_363110_, float p_368202_) {
        p_368871_.ifStarted(p_368242_ -> ModMobModel.animate(this, p_365491_, (long)((float)((ModAnimationState)((Object)p_368242_)).getTimeInMillis(p_363110_) * p_368202_), 1.0f, ANIMATION_VECTOR_CACHE));
    }

    protected void applyStatic(AnimationDefinition p_369884_) {
        ModMobModel.animate(this, p_369884_, 0L, 1.0f, ANIMATION_VECTOR_CACHE);
    }

    public static Optional<ModelPart> getAnyDescendantWithName(ModMobModel p_362391_, String p_363872_) {
        Stream stream = p_362391_.root().getAllParts().toList().stream();
        return p_363872_.equals("root") ? Optional.of(p_362391_.root()) : stream.filter(p_364767_ -> p_364767_.hasChild(p_363872_)).findFirst().map(p_366385_ -> p_366385_.getChild(p_363872_));
    }

    public static void animate(ModMobModel p_362391_, AnimationDefinition p_232321_, long p_232322_, float p_232323_, Vector3f p_253861_) {
        float f = ModMobModel.getElapsedSeconds(p_232321_, p_232322_);
        for (Map.Entry entry : p_232321_.boneAnimations().entrySet()) {
            Optional<ModelPart> optional = ModMobModel.getAnyDescendantWithName(p_362391_, (String)entry.getKey());
            List list = (List)entry.getValue();
            optional.ifPresent(p_232330_ -> list.forEach(p_288241_ -> {
                Keyframe[] akeyframe = p_288241_.keyframes();
                int i = Math.max(0, Mth.binarySearch((int)0, (int)akeyframe.length, p_232315_ -> f <= akeyframe[p_232315_].timestamp()) - 1);
                int j = Math.min(akeyframe.length - 1, i + 1);
                Keyframe keyframe = akeyframe[i];
                Keyframe keyframe1 = akeyframe[j];
                float f1 = f - keyframe.timestamp();
                float f2 = j != i ? Mth.clamp((float)(f1 / (keyframe1.timestamp() - keyframe.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe1.interpolation().apply(p_253861_, f2, akeyframe, i, j, p_232323_);
                p_288241_.target().apply(p_232330_, p_253861_);
            }));
        }
    }

    public static float getElapsedSeconds(AnimationDefinition p_232317_, long p_232318_) {
        float f = (float)p_232318_ / 1000.0f;
        return p_232317_.looping() ? f % p_232317_.lengthInSeconds() : f;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.rootz.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

