/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.westerngorilla.mob.goals;

import aquariusplayz.animalgarden.westerngorilla.mob.ModMob;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;

public class ModBreedGoal
extends Goal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.forNonCombat().range(8.0).ignoreLineOfSight();
    protected final ModMob animal;
    private final Class<? extends ModMob> partnerClass;
    protected final ServerLevel level;
    protected ModMob partner;
    private int loveTime;
    private final double speedModifier;

    public ModBreedGoal(ModMob p_25122_, double p_25123_) {
        this(p_25122_, p_25123_, ((Object)((Object)p_25122_)).getClass());
    }

    public ModBreedGoal(ModMob p_25125_, double p_25126_, Class<? extends ModMob> p_25127_) {
        this.animal = p_25125_;
        this.level = ModBreedGoal.getServerLevel((Entity)p_25125_);
        this.partnerClass = p_25127_;
        this.speedModifier = p_25126_;
    }

    public boolean canUse() {
        if (this.animal.getBehaviorType() == 4) {
            return false;
        }
        if (!this.animal.isInLove()) {
            return false;
        }
        this.partner = this.getFreePartner();
        if (this.partner == null) {
            return false;
        }
        return this.partner != null && this.animal.getGender() != this.partner.getGender();
    }

    public boolean canContinueToUse() {
        if (this.animal.getBehaviorType() == 4) {
            return false;
        }
        return this.partner.isAlive() && this.partner.isInLove() && this.loveTime < 60 && !this.partner.isPanicking();
    }

    public void stop() {
        this.partner = null;
        this.loveTime = 0;
    }

    public void tick() {
        this.animal.getLookControl().setLookAt((Entity)this.partner, 10.0f, (float)this.animal.getMaxHeadXRot());
        this.animal.getNavigation().moveTo((Entity)this.partner, this.speedModifier);
        ++this.loveTime;
        if (this.loveTime >= this.adjustedTickDelay(60) && this.animal.distanceToSqr((Entity)this.partner) < 9.0) {
            this.breed();
        }
    }

    private ModMob getFreePartner() {
        List list = this.level.getNearbyEntities(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.animal, this.animal.getBoundingBox().inflate(8.0));
        double d0 = Double.MAX_VALUE;
        ModMob animal = null;
        for (ModMob animal1 : list) {
            if (!this.animal.canMate((Animal)animal1) || animal1.isPanicking() || !(this.animal.distanceToSqr((Entity)animal1) < d0)) continue;
            animal = animal1;
            d0 = this.animal.distanceToSqr((Entity)animal1);
        }
        return animal;
    }

    protected void breed() {
        this.animal.spawnChildFromBreeding(this.level, (Animal)this.partner);
    }
}

