/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.fastmotd;

import java.util.List;
import java.util.Map;
import net.elytrium.fastmotd.FastMOTD;
import net.elytrium.fastmotd.thirdparty.commons.kyori.serialization.Serializers;
import net.elytrium.fastmotd.thirdparty.serializer.annotations.Comment;
import net.elytrium.fastmotd.thirdparty.serializer.annotations.CommentValue;
import net.elytrium.fastmotd.thirdparty.serializer.annotations.Final;
import net.elytrium.fastmotd.thirdparty.serializer.language.object.YamlSerializable;

public class Settings
extends YamlSerializable {
    public static final Settings IMP = new Settings();
    @Final
    public String VERSION = "1.0.9";
    @Comment(value={@CommentValue(value="Available serializers:"), @CommentValue(value="LEGACY_AMPERSAND - \"&c&lExample &c&9Text\"."), @CommentValue(value="LEGACY_SECTION - \"\u00a7c\u00a7lExample \u00a7c\u00a79Text\"."), @CommentValue(value="MINIMESSAGE - \"<bold><red>Example</red> <blue>Text</blue></bold>\". (https://webui.adventure.kyori.net/)"), @CommentValue(value="GSON - \"[{\"text\":\"Example\",\"bold\":true,\"color\":\"red\"},{\"text\":\" \",\"bold\":true},{\"text\":\"Text\",\"bold\":true,\"color\":\"blue\"}]\". (https://minecraft.tools/en/json_text.php/)"), @CommentValue(value="GSON_COLOR_DOWNSAMPLING - Same as GSON, but uses downsampling.")})
    public Serializers SERIALIZER = Serializers.MINIMESSAGE;
    public MAIN MAIN = new MAIN();
    public MAINTENANCE MAINTENANCE = new MAINTENANCE();
    public SHUTDOWN_SCHEDULER SHUTDOWN_SCHEDULER = new SHUTDOWN_SCHEDULER();

    public static class MAIN {
        public boolean ENABLE_UPDATES = true;
        public String VERSION_NAME = "Elytrium";
        public List<String> DESCRIPTIONS = List.of("<bold><red>FastMOTD</red></bold>{NL} -> Really fast.");
        public List<String> FAVICONS = List.of("server-icon.png");
        public List<String> INFORMATION = List.of("This is the", "<bold>best server</bold>", "<gradient:green:red>made ever</gradient>", "trust me");
        @Comment(value={@CommentValue(value="How frequently online player count will be updated (in ms)")})
        public long UPDATE_RATE = 3000L;
        @Comment(value={@CommentValue(value="VARIABLE - from max-count parameter"), @CommentValue(value="ADD_SOME - will add up the number from max-count parameter to current online players amount")})
        public FastMOTD.MaxCountType MAX_COUNT_TYPE = FastMOTD.MaxCountType.VARIABLE;
        public int MAX_COUNT = 4444;
        public int FAKE_ONLINE_ADD_SINGLE = 5;
        public int FAKE_ONLINE_ADD_PERCENT = 20;
        @Comment(value={@CommentValue(value="Accepted values: from 0.0 to 1.0."), @CommentValue(value="Keep this value as low as possible"), @CommentValue(value="Set -1 to disable PNG recompression")})
        public double PNG_QUALITY = 0.0;
        @Comment(value={@CommentValue(value="Write packets outside of Netty pipeline to avoid plugins that modify packets (e.g. PacketEvents)")})
        public boolean DIRECT_WRITE = false;
        public boolean LOG_PINGS = false;
        public boolean LOG_IMPROPER_PINGS = false;
        @Comment(value={@CommentValue(value="Enabling this will allow non-vanilla ping packets sequence,"), @CommentValue(value="but will open your server to nullping attacks")})
        public boolean ALLOW_IMPROPER_PINGS = false;
        public VERSIONS VERSIONS = new VERSIONS();
        public Map<String, DOMAIN_MOTD_NODE> DOMAINS = Map.of("example.com:25565", new DOMAIN_MOTD_NODE());

        @Comment(value={@CommentValue(value="Separate MOTDs/favicons/information for different protocol versions"), @CommentValue(value="See https://wiki.vg/Protocol_version_numbers")})
        public static class VERSIONS {
            @Comment(value={@CommentValue(value="{} = disabled")})
            public Map<String, List<String>> DESCRIPTIONS = Map.of("757-759", List.of("<bold><red>FastMOTD</red></bold>{NL} -> Supports separate MOTDs for different versions."));
            @Comment(value={@CommentValue(value="{} = disabled")})
            public Map<String, List<String>> FAVICONS = Map.of("756-758", List.of("second-server-icon.png"));
            @Comment(value={@CommentValue(value="{} = disabled")})
            public Map<String, List<String>> INFORMATION = Map.of("757-758", List.of("Your", "protocol", "version", "is 757 or 758"));
        }
    }

    public static class MAINTENANCE {
        public boolean MAINTENANCE_ENABLED = false;
        public boolean SHOW_VERSION = true;
        public boolean SHOULD_KICK_ON_JOIN = true;
        public List<String> KICK_WHITELIST = List.of("127.0.0.1");
        public String KICK_MESSAGE = "<red>Try to join the server later</red>";
        public String VERSION_NAME = "MAINTENANCE MODE ENABLED!!";
        public List<String> DESCRIPTIONS = List.of("<bold><red>FastMOTD</red></bold>{NL} -> Really fast. (in maintenance mode too)");
        public List<String> FAVICONS = List.of("server-icon.png");
        public List<String> INFORMATION = List.of("Contact support: https://elytrium.net/discord");
        @Comment(value={@CommentValue(value="-1 = disabled")})
        public int OVERRIDE_ONLINE = -1;
        @Comment(value={@CommentValue(value="-1 = disabled")})
        public int OVERRIDE_MAX_ONLINE = -1;
        public VERSIONS VERSIONS = new VERSIONS();
        public Map<String, DOMAIN_MOTD_NODE> DOMAINS = Map.of("example.com:25565", new DOMAIN_MOTD_NODE());
        public COMMAND COMMAND = new COMMAND();

        @Comment(value={@CommentValue(value="Separate MOTDs/favicons/information for different protocol versions"), @CommentValue(value="See https://wiki.vg/Protocol_version_numbers")})
        public static class VERSIONS {
            @Comment(value={@CommentValue(value="{} = disabled")})
            public Map<String, List<String>> DESCRIPTIONS = Map.of("757-759", List.of("<bold><red>FastMOTD</red></bold>{NL} -> Really Fast."));
            @Comment(value={@CommentValue(value="{} = disabled")})
            public Map<String, List<String>> FAVICONS = Map.of("758-758", List.of("second-server-icon.png"));
            @Comment(value={@CommentValue(value="{} = disabled")})
            public Map<String, List<String>> INFORMATION = Map.of("756-759", List.of("Server is", "under", "maintenance"));
        }

        public static class COMMAND {
            public String USAGE = "FastMOTD <gold>>></gold> Usage: <gold>/maintenance <off|on|toggle></gold>";
        }
    }

    public static class SHUTDOWN_SCHEDULER {
        @Comment(value={@CommentValue(value="Server will stop accepting new connections")})
        public boolean SHUTDOWN_SCHEDULER_ENABLED = false;
        @Comment(value={@CommentValue(value="Server will shut down after everyone has left the server")})
        public boolean SHUTDOWN_ON_ZERO_PLAYERS = false;
        public List<String> WHITELIST = List.of("127.0.0.1");
    }

    public static class DOMAIN_MOTD_NODE {
        public List<String> DESCRIPTION = List.of("Description for example.com");
        public List<String> FAVICON = List.of("example-com-server-icon.png");
        public List<String> INFORMATION = List.of("Information for example.com");
    }
}

