/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.fastmotd.command;

import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.permission.Tristate;
import java.util.List;
import net.elytrium.fastmotd.FastMOTD;
import net.elytrium.fastmotd.Settings;
import net.kyori.adventure.text.Component;

public class MaintenanceCommand
implements SimpleCommand {
    private final FastMOTD plugin;
    private final Component usage;

    public MaintenanceCommand(FastMOTD plugin, Component usage) {
        this.plugin = plugin;
        this.usage = usage;
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        return ImmutableList.of((Object)"off", (Object)"on", (Object)"toggle");
    }

    public void execute(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        CommandSource source = invocation.source();
        if (args.length < 1) {
            source.sendMessage(this.usage);
            return;
        }
        switch (args[0]) {
            case "off": {
                Settings.IMP.MAINTENANCE.MAINTENANCE_ENABLED = false;
                break;
            }
            case "on": {
                Settings.IMP.MAINTENANCE.MAINTENANCE_ENABLED = true;
                break;
            }
            case "toggle": {
                Settings.IMP.MAINTENANCE.MAINTENANCE_ENABLED ^= true;
                break;
            }
            default: {
                source.sendMessage(this.usage);
                return;
            }
        }
        Settings.IMP.save(this.plugin.getConfigPath());
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().getPermissionValue("fastmotd.maintenance") == Tristate.TRUE;
    }
}

