/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.fastmotd.holder;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.server.ServerPing;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.elytrium.fastmotd.holder.MOTDBytesHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ComponentSerializer;

public class MOTDHolder {
    private final MOTDBytesHolder legacyHolder;
    private final MOTDBytesHolder modernHolder;

    public MOTDHolder(ComponentSerializer<Component, Component, String> serializer, String versionName, String descriptionSerialized, String favicon, List<String> information) {
        String name = versionName.replace("\"", "\\\"");
        Component description = serializer.deserialize((Object)descriptionSerialized.replace("{NL}", "\n"));
        this.legacyHolder = new MOTDBytesHolder(serializer, ProtocolUtils.getJsonChatSerializer((ProtocolVersion)ProtocolVersion.MINECRAFT_1_15_2), name, description, favicon, information);
        this.modernHolder = new MOTDBytesHolder(serializer, ProtocolUtils.getJsonChatSerializer((ProtocolVersion)ProtocolVersion.MINECRAFT_1_16), name, description, favicon, information);
    }

    public void replaceOnline(int max, int online) {
        this.legacyHolder.replaceOnline(max, online);
        this.modernHolder.replaceOnline(max, online);
    }

    public ByteBuf getByteBuf(ProtocolVersion version, boolean replaceProtocol) {
        if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_16) >= 0) {
            return this.modernHolder.getByteBuf(version, replaceProtocol);
        }
        return this.legacyHolder.getByteBuf(version, replaceProtocol);
    }

    public ServerPing getCompatPingInfo(ProtocolVersion version, boolean replaceProtocol) {
        if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_16) >= 0) {
            return this.modernHolder.getCompatPingInfo(version, replaceProtocol);
        }
        return this.legacyHolder.getCompatPingInfo(version, replaceProtocol);
    }

    public void dispose() {
        this.legacyHolder.dispose();
        this.modernHolder.dispose();
    }
}

