/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.fastmotd.thirdparty.commons.velocity.commands;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class RateLimitedCommand
implements SimpleCommand {
    Cache<CommandSource, Boolean> executeCache = Caffeine.newBuilder().expireAfterWrite(this.getExecuteDelay(), TimeUnit.MILLISECONDS).build();
    Cache<CommandSource, Boolean> suggestCache = Caffeine.newBuilder().expireAfterWrite(this.getSuggestDelay(), TimeUnit.MILLISECONDS).build();

    public void execute(SimpleCommand.Invocation invocation) {
        if (this.executeCache.getIfPresent((Object)invocation.source()) == null) {
            this.executeCache.put((Object)invocation.source(), (Object)Boolean.TRUE);
            this.onExecuteSuccess(invocation);
        } else {
            this.onExecuteLimited(invocation);
        }
    }

    public abstract void onExecuteSuccess(SimpleCommand.Invocation var1);

    public abstract void onExecuteLimited(SimpleCommand.Invocation var1);

    public abstract long getExecuteDelay();

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        if (this.suggestCache.getIfPresent((Object)invocation.source()) == null) {
            this.suggestCache.put((Object)invocation.source(), (Object)Boolean.TRUE);
            return this.onSuggestSuccess(invocation);
        }
        return this.onSuggestLimited(invocation);
    }

    public abstract List<String> onSuggestSuccess(SimpleCommand.Invocation var1);

    public abstract List<String> onSuggestLimited(SimpleCommand.Invocation var1);

    public abstract long getSuggestDelay();
}

