/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.fastmotd.thirdparty.fastprepare.handler;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.util.function.Function;
import net.elytrium.fastmotd.thirdparty.fastprepare.PreparedPacket;
import net.elytrium.fastmotd.thirdparty.fastprepare.PreparedPacketFactory;
import net.elytrium.fastmotd.thirdparty.fastprepare.dummy.DummyPacket;

public class PreparedPacketEncoder
extends ChannelOutboundHandlerAdapter {
    private final ProtocolVersion protocolVersion;
    private final Function<ByteBuf, ByteBuf> duplicateFunction;
    private PreparedPacketFactory factory;
    private boolean shouldSendUncompressed = true;

    public PreparedPacketEncoder(PreparedPacketFactory factory, ProtocolVersion protocolVersion, boolean shouldCopy) {
        this.factory = factory;
        this.protocolVersion = protocolVersion;
        this.duplicateFunction = shouldCopy ? ByteBuf::copy : ByteBuf::retainedDuplicate;
    }

    public PreparedPacketEncoder(PreparedPacketFactory factory, ProtocolVersion protocolVersion, Function<ByteBuf, ByteBuf> duplicateFunction) {
        this.factory = factory;
        this.protocolVersion = protocolVersion;
        this.duplicateFunction = duplicateFunction;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof DummyPacket) {
            return;
        }
        if (msg instanceof PreparedPacket) {
            ByteBuf cachedPacket;
            PreparedPacket preparedPacket = (PreparedPacket)msg;
            if (this.factory.isCompatibilityMode()) {
                ByteBuf uncompressedPacket = preparedPacket.getUncompressedPackets(this.protocolVersion);
                if (uncompressedPacket == null) {
                    throw new IllegalStateException("Failed to find compatible uncompressed packet for " + this.protocolVersion);
                }
                ByteBuf uncompressed = uncompressedPacket.slice();
                while (uncompressed.isReadable()) {
                    ctx.write((Object)uncompressed.readBytes(ProtocolUtils.readVarInt((ByteBuf)uncompressed)), promise);
                    if (promise.isVoid()) continue;
                    promise = ctx.newPromise();
                }
                return;
            }
            ByteBuf byteBuf = cachedPacket = this.isSendUncompressed() ? preparedPacket.getUncompressedPackets(this.protocolVersion) : preparedPacket.getPackets(this.protocolVersion);
            if (cachedPacket == null) {
                throw new IllegalStateException("Current PreparedPacket is not prepared for " + this.protocolVersion);
            }
            ctx.write((Object)this.duplicateFunction.apply(cachedPacket), promise);
        } else if (msg instanceof MinecraftPacket && !this.factory.isCompatibilityMode()) {
            if (this.isSendUncompressed()) {
                ctx.write((Object)this.factory.encodeSingle((MinecraftPacket)msg, this.protocolVersion, false, ctx.alloc()), promise);
            } else {
                ctx.write((Object)this.factory.encodeSingle((MinecraftPacket)msg, this.protocolVersion, ctx.alloc()), promise);
            }
        } else {
            ctx.write(msg, promise);
        }
    }

    public boolean isSendUncompressed() {
        return this.factory.shouldSaveUncompressed() && this.shouldSendUncompressed;
    }

    public PreparedPacketFactory getFactory() {
        return this.factory;
    }

    public void setFactory(PreparedPacketFactory factory) {
        this.factory = factory;
    }

    public void setShouldSendUncompressed(boolean shouldSendUncompressed) {
        this.shouldSendUncompressed = shouldSendUncompressed;
    }
}

