/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.fastmotd.thirdparty.serializer.language.reader;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.elytrium.fastmotd.thirdparty.serializer.SerializerConfig;
import net.elytrium.fastmotd.thirdparty.serializer.annotations.FallbackNodeNames;
import net.elytrium.fastmotd.thirdparty.serializer.annotations.Final;
import net.elytrium.fastmotd.thirdparty.serializer.annotations.OverrideNameStyle;
import net.elytrium.fastmotd.thirdparty.serializer.annotations.RegisterPlaceholders;
import net.elytrium.fastmotd.thirdparty.serializer.annotations.Transient;
import net.elytrium.fastmotd.thirdparty.serializer.language.object.YamlSerializable;
import net.elytrium.fastmotd.thirdparty.serializer.language.reader.AbstractReader;
import net.elytrium.fastmotd.thirdparty.serializer.language.writer.YamlWriter;
import net.elytrium.fastmotd.thirdparty.serializer.placeholders.DefaultPlaceholderReplacer;
import net.elytrium.fastmotd.thirdparty.serializer.placeholders.PlaceholderReplacer;
import net.elytrium.fastmotd.thirdparty.serializer.placeholders.Placeholders;
import net.elytrium.fastmotd.thirdparty.serializer.utils.GenericUtils;

public class YamlReader
extends AbstractReader {
    private static final Logger LOGGER = Logger.getLogger(YamlReader.class.getName());
    private final YamlSerializable yamlSerializable;
    private int currentIndent;
    private int seekIndent;
    private int nodeIndent;
    private int newLineIndent;
    private boolean tempRestoreNewLine;
    private boolean bracketOpened;
    private boolean startOfFile = true;
    private StringBuilder spacesBuffer;

    public YamlReader(BufferedReader reader, SerializerConfig config) {
        super(config, reader);
        this.yamlSerializable = null;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public YamlReader(BufferedReader reader, SerializerConfig config, YamlSerializable serializable) {
        super(config, reader);
        this.yamlSerializable = serializable;
    }

    public YamlReader(BufferedReader reader) {
        super(reader);
        this.yamlSerializable = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SA_FIELD_SELF_COMPARISON"})
    public void readSerializableObject(@Nullable Field owner, Object holder, Class<?> clazz) {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            this.unsetTempRestoreNewLine();
            this.readBeginSerializableObject(owner);
            Field[] nodes = clazz.getDeclaredFields();
            if (nodes.length != 0) {
                try {
                    String nodeName;
                    HashMap<String, Field> nodeFieldMap = new HashMap<String, Field>();
                    for (Field node : nodes) {
                        try {
                            node.setAccessible(true);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        Object value = node.get(holder);
                        this.removePlaceholders(value);
                        this.updatePlaceholders(node, value);
                        OverrideNameStyle overrideNameStyle = node.getAnnotation(OverrideNameStyle.class);
                        if (overrideNameStyle == null) {
                            overrideNameStyle = node.getType().getAnnotation(OverrideNameStyle.class);
                        }
                        nodeFieldMap.put(overrideNameStyle == null ? this.config.toNodeName(node.getName()) : this.config.toNodeName(node.getName(), overrideNameStyle.field(), overrideNameStyle.node()), node);
                        FallbackNodeNames fallbackNodeNames = node.getAnnotation(FallbackNodeNames.class);
                        if (fallbackNodeNames == null) continue;
                        for (String fallbackNodeName : fallbackNodeNames.value()) {
                            nodeFieldMap.put(fallbackNodeName, node);
                        }
                    }
                    int correctIndent = this.currentIndent;
                    while (correctIndent == this.currentIndent && (nodeName = this.readNodeName(owner)) != null) {
                        block21: {
                            try {
                                Field node = (Field)nodeFieldMap.get(nodeName);
                                if (node == null) {
                                    this.skipGuessingType(owner);
                                    this.setBackupPreferred();
                                    if (this.config.isLogMissingFields()) {
                                        LOGGER.log(Level.WARNING, "Skipping node " + nodeName + " due to missing field");
                                    }
                                } else {
                                    int modifiers = node.getModifiers();
                                    if (!(Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || Modifier.isTransient(modifiers) || node.getAnnotation(Final.class) != null || node.getType().getAnnotation(Final.class) != null || node.getAnnotation(Transient.class) != null || node.getType().getAnnotation(Transient.class) != null)) {
                                        this.removePlaceholders(node.get(holder));
                                        this.updatePlaceholders(node, this.readNode(holder, node));
                                    } else {
                                        this.skipNode(node);
                                    }
                                }
                            }
                            catch (ReflectiveOperationException e) {
                                this.skipGuessingType(owner);
                                this.setBackupPreferred();
                                if (!this.config.isLogMissingFields()) break block21;
                                LOGGER.log(Level.WARNING, "Skipping node " + nodeName + " due to exception caught", e);
                            }
                        }
                        this.readSerializableObjectEntryJoin(owner);
                        if (this.readEndSerializableObject(owner)) {
                            return;
                        }
                        if (correctIndent == this.currentIndent) continue;
                        while (this.skipComments(owner, this.readRaw(), true)) {
                        }
                    }
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
            this.readEndSerializableObject(owner);
        }
    }

    private void removePlaceholders(Object value) throws ReflectiveOperationException {
        Placeholders.removePlaceholders(value);
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object entry : collection) {
                Placeholders.removePlaceholders(entry);
            }
        }
    }

    private void updatePlaceholders(Field node, Object value) throws ReflectiveOperationException {
        RegisterPlaceholders placeholders = node.getAnnotation(RegisterPlaceholders.class);
        if (placeholders == null) {
            placeholders = node.getType().getAnnotation(RegisterPlaceholders.class);
        }
        if (placeholders != null) {
            PlaceholderReplacer<Object, Object> replacer = null;
            if (placeholders.replacer() == DefaultPlaceholderReplacer.class) {
                PlaceholderReplacer<Object, Object> placeholderReplacer = replacer = value instanceof Collection ? this.config.getRegisteredReplacer((Class)GenericUtils.getParameterType(Collection.class, node.getGenericType(), 0)) : this.config.getRegisteredReplacer(node.getType());
            }
            if (replacer == null) {
                replacer = this.config.getAndCacheReplacer(placeholders.replacer());
            }
            if (this.config.isRegisterPlaceholdersForCollectionEntries() && value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object entry : collection) {
                    Placeholders.addPlaceholders(entry, replacer, placeholders.wrapWithBraces(), placeholders.value());
                }
            }
            Placeholders.addPlaceholders(value, replacer, placeholders.wrapWithBraces(), placeholders.value());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readNodeName(@Nullable Field owner) {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            char marker = this.readRawIgnoreEmptyAndNewLines();
            return marker == '\u0000' ? null : this.readNodeNameFromMarker(owner, marker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readBeginSerializableObject(@Nullable Field owner) {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            this.skipChar('{');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readSerializableObjectEntryJoin(@Nullable Field owner) {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            this.skipChar(',');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readEndSerializableObject(@Nullable Field owner) {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            return this.skipChar('}');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readGuessingType(@Nullable Field owner) {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            return this.readGuessingTypeFromMarker(owner, this.readRawIgnoreEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C extends Map<Object, Object>> C readMap(@Nullable Field owner, C result, Type keyType, Type valueType) {
        boolean startOfFile = this.startOfFile;
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            char marker = this.readRawIgnoreEmpty();
            if (startOfFile) {
                this.setTempRestoreNewLine();
            }
            return this.readMapFromMarker(owner, result, keyType, valueType, marker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C extends Collection<Object>> C readCollection(@Nullable Field owner, C result, Type type) {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            return this.readCollectionFromMarker(owner, result, type, this.readRawIgnoreEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Character readCharacter(@Nullable Field owner) {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            return this.readCharacterFromMarker(owner, this.readRawIgnoreEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean readBoolean(@Nullable Field owner) {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            return Boolean.valueOf(this.readString(owner));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double readDouble(@Nullable Field owner) throws NumberFormatException {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            String value = this.readString(owner);
            return value == null ? null : Double.valueOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long readLong(@Nullable Field owner) throws NumberFormatException {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            String value = this.readString(owner);
            return value == null ? null : Long.valueOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readString(@Nullable Field owner) {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            return this.readStringFromMarker(owner, this.readRawIgnoreEmpty(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readNodeNameFromMarker(@Nullable Field owner, char marker) {
        String nodeName;
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            this.nodeIndent = this.currentIndent;
        }
        while (this.skipComments(owner, marker, false) || this.skipComments(owner, this.readRawIgnoreEmpty(), true)) {
            marker = this.readRaw();
        }
        if (marker == '\"' || marker == '\'') {
            nodeName = this.readStringFromMarker(owner, marker, true);
        } else {
            StringBuilder result = new StringBuilder(12);
            while (true) {
                if (marker != ':') {
                    if (this.isEndMarker(marker)) {
                        throw new IllegalStateException("Got a new line in node name: " + result);
                    }
                    result.append(marker);
                    marker = this.readRaw();
                    continue;
                }
                marker = this.readRaw();
                if (Character.isWhitespace(marker)) break;
                result.append(':');
            }
            this.setReuseBuffer();
            nodeName = result.toString();
        }
        return nodeName;
    }

    private Object readGuessingTypeFromMarker(@Nullable Field owner, char marker) {
        Object object;
        switch (marker) {
            case '\n': {
                Object object2;
                char nextMarker = this.readRawIgnoreEmpty();
                this.setReuseBuffer();
                object = object2 = nextMarker == '-' ? this.readListFromMarker(owner, marker) : this.readMapFromMarker(owner, marker);
                break;
            }
            case '-': {
                this.setReuseBuffer();
                this.setSeek();
                String string = this.readString(owner);
                if (string != null) {
                    try {
                        Long l = Long.parseLong(string);
                        object = l;
                        break;
                    }
                    catch (NumberFormatException e2) {
                        try {
                            Double d = Double.parseDouble(string);
                            object = d;
                            break;
                        }
                        catch (NumberFormatException e2) {
                            // empty catch block
                        }
                    }
                }
                this.unsetSeek();
                List<Object> list = this.readListFromMarker(owner, '\n');
                object = list;
                break;
            }
            case '[': {
                List<Object> list = this.readListFromMarker(owner, marker);
                object = list;
                break;
            }
            case '{': {
                Map<Object, Object> map = this.readMapFromMarker(owner, marker);
                object = map;
                break;
            }
            case '\"': 
            case '\'': 
            case '>': 
            case '|': {
                String string = this.readStringFromMarker(owner, marker, false);
                object = string;
                break;
            }
            default: {
                if (this.isNullSkippedFromMarker(marker)) {
                    Object var3_13 = null;
                    object = var3_13;
                    break;
                }
                this.setSeekFromMarker(marker);
                String string = this.readStringFromMarker(owner, marker, false);
                if (string == null) {
                    Object var3_14 = null;
                    object = var3_14;
                    break;
                }
                if (string.endsWith(":") || string.endsWith(": ") || string.contains(": ")) {
                    this.unsetSeek();
                    this.unsetTempRestoreNewLine();
                    Map<Object, Object> map = this.readMapFromMarker(owner, '\n');
                    object = map;
                    break;
                }
                this.clearSeek();
                try {
                    Long l = Long.parseLong(string);
                    object = l;
                }
                catch (NumberFormatException e) {
                    try {
                        Double d = Double.parseDouble(string);
                        object = d;
                    }
                    catch (NumberFormatException e3) {
                        String string2 = string;
                        object = string2;
                    }
                }
                break;
            }
        }
        return object;
    }

    private Map<Object, Object> readMapFromMarker(@Nullable Field owner, char marker) {
        return this.readMapFromMarker(owner, (Map)new LinkedHashMap(), (Type)((Object)Object.class), (Type)((Object)Object.class), marker);
    }

    @SuppressFBWarnings(value={"SA_FIELD_SELF_COMPARISON"})
    private <C extends Map<Object, Object>> C readMapFromMarker(@Nullable Field owner, C result, Type keyType, Type valueType, char marker) {
        char nextMarker;
        if (this.skipComments(owner, marker, false)) {
            marker = (char)10;
        }
        if (this.tempRestoreNewLine) {
            nextMarker = marker;
            marker = (char)10;
            this.unsetTempRestoreNewLine();
        } else {
            nextMarker = this.readRawIgnoreEmptyAndNewLines();
        }
        boolean previousBracketOpened = this.bracketOpened;
        switch (marker) {
            case '{': {
                this.bracketOpened = true;
                while (nextMarker != '}') {
                    this.readMapEntry(owner, keyType, valueType, this.readNodeNameFromMarker(null, nextMarker), result);
                    nextMarker = this.readRawIgnoreEmptyAndNewLines();
                }
                this.bracketOpened = previousBracketOpened;
                break;
            }
            case '\n': {
                this.bracketOpened = false;
                int correctIndent = this.currentIndent;
                while (nextMarker != '\u0000' && correctIndent == this.currentIndent) {
                    this.readMapEntry(owner, keyType, valueType, this.readNodeNameFromMarker(null, nextMarker), result);
                    nextMarker = this.readRawIgnoreEmptyAndNewLines();
                    if (!this.skipComments(owner, nextMarker, false)) continue;
                    nextMarker = this.readRawIgnoreEmptyAndNewLines();
                }
                this.setReuseBuffer();
                this.bracketOpened = previousBracketOpened;
                break;
            }
            default: {
                if (this.isNullSkippedFromMarker(marker)) {
                    return null;
                }
                throw new IllegalStateException("Got unknown marker when reading map: " + marker);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readMapEntry(@Nullable Field owner, Type keyType, Type valueType, String nodeName, Map<Object, Object> result) {
        Object key;
        if (keyType == Object.class) {
            try {
                try {
                    key = Long.parseLong(nodeName);
                }
                catch (NumberFormatException e) {
                    key = Double.parseDouble(nodeName);
                }
            }
            catch (NumberFormatException e) {
                key = nodeName;
            }
        } else {
            if (!(keyType instanceof Class)) throw new IllegalStateException("Type " + keyType + " for map key are not supported yet!");
            Class keyClazz = (Class)keyType;
            if (String.class.isAssignableFrom(keyClazz)) {
                key = nodeName;
            } else if (Character.class.isAssignableFrom(keyClazz) || Character.TYPE.isAssignableFrom(keyClazz)) {
                if (nodeName.isEmpty()) {
                    throw new IllegalStateException("Character can't be null!");
                }
                key = Character.valueOf(nodeName.charAt(0));
            } else if (keyClazz.isEnum()) {
                key = Enum.valueOf(keyClazz, nodeName);
            } else if (Boolean.class.isAssignableFrom(keyClazz) || Boolean.TYPE.isAssignableFrom(keyClazz)) {
                key = Boolean.valueOf(nodeName);
            } else if (Number.class.isAssignableFrom(keyClazz) || keyClazz.isPrimitive()) {
                if (Double.class.isAssignableFrom(keyClazz) || Double.TYPE.isAssignableFrom(keyClazz)) {
                    key = Double.valueOf(nodeName);
                } else if (Float.class.isAssignableFrom(keyClazz) || Float.TYPE.isAssignableFrom(keyClazz)) {
                    key = Float.valueOf(nodeName);
                } else if (Long.class.isAssignableFrom(keyClazz) || Long.TYPE.isAssignableFrom(keyClazz)) {
                    key = Long.valueOf(nodeName);
                } else if (Integer.class.isAssignableFrom(keyClazz) || Integer.TYPE.isAssignableFrom(keyClazz)) {
                    key = Integer.valueOf(nodeName);
                } else if (Short.class.isAssignableFrom(keyClazz) || Short.TYPE.isAssignableFrom(keyClazz)) {
                    key = Short.valueOf(nodeName);
                } else {
                    if (!Byte.class.isAssignableFrom(keyClazz) && !Byte.TYPE.isAssignableFrom(keyClazz)) throw new IllegalStateException("Number " + keyClazz + " for map key are not supported yet!");
                    key = Byte.valueOf(nodeName);
                }
            } else {
                ArrayDeque serializerStack = new ArrayDeque(Math.min(16, this.config.getRegisteredSerializers() + 1));
                Type type = this.fillSerializerStack(serializerStack, keyClazz);
                if (serializerStack.isEmpty()) {
                    throw new IllegalStateException("Class " + keyClazz + " for map key are not supported yet!");
                }
                if (!(type instanceof Class) || Map.class.isAssignableFrom((Class)type) || Collection.class.isAssignableFrom((Class)type)) {
                    throw new IllegalStateException("Class " + type + " for map key is not supported!");
                }
                key = this.readAndDeserializeByType(owner, null, type, serializerStack);
            }
        }
        result.put(key, this.readByType0(owner, valueType));
    }

    private List<Object> readListFromMarker(@Nullable Field owner, char marker) {
        return this.readCollectionFromMarker(owner, (Collection)new ArrayList(), (Type)((Object)Object.class), marker);
    }

    @SuppressFBWarnings(value={"SA_FIELD_SELF_COMPARISON"})
    private <C extends Collection<Object>> C readCollectionFromMarker(@Nullable Field owner, C result, Type type, char marker) {
        if (this.skipComments(owner, marker, false)) {
            marker = (char)10;
        }
        this.unsetTempRestoreNewLine();
        switch (marker) {
            case '[': {
                char nextMarker = this.readRawIgnoreEmptyAndNewLines();
                while (nextMarker != ']') {
                    result.add((Object)this.readByType0(owner, type));
                    nextMarker = this.readRawIgnoreEmptyAndNewLines();
                }
                break;
            }
            case '\n': {
                this.skipComments(owner, this.readRawIgnoreEmpty(), true);
                char nextMarker = this.readRawIgnoreEmpty();
                if (nextMarker != '-') {
                    throw new IllegalStateException("Got unknown marker when reading list: " + nextMarker);
                }
            }
            case '-': {
                this.nodeIndent = this.currentIndent;
                char nextMarker = '-';
                int correctIndent = this.currentIndent;
                while (nextMarker == '-' && correctIndent == this.currentIndent) {
                    this.setTempRestoreNewLine();
                    result.add((Object)this.readByType0(null, type));
                    this.unsetTempRestoreNewLine();
                    nextMarker = this.readRawIgnoreEmptyAndNewLines();
                    if (!this.skipComments(owner, nextMarker, false)) continue;
                    nextMarker = this.readRawIgnoreEmptyAndNewLines();
                }
                this.setReuseBuffer();
                break;
            }
            default: {
                if (this.isNullSkippedFromMarker(marker)) {
                    return null;
                }
                throw new IllegalStateException("Got unknown marker when reading list: " + marker);
            }
        }
        return result;
    }

    private Object readByType0(@Nullable Field owner, Type type) {
        Object result = this.readByType(owner, type);
        return type == Integer.class || type == Integer.TYPE ? Integer.valueOf(((Long)result).intValue()) : (type == Short.class || type == Short.TYPE ? Short.valueOf(((Long)result).shortValue()) : (type == Byte.class || type == Byte.TYPE ? Byte.valueOf(((Long)result).byteValue()) : (type == Float.class || type == Float.TYPE ? Float.valueOf(((Double)result).floatValue()) : result)));
    }

    private Character readCharacterFromMarker(@Nullable Field owner, char marker) {
        Character result = null;
        block0 : switch (marker) {
            case '\"': {
                while ((marker = this.readRaw()) != '\"') {
                    if (result == null) {
                        if (marker == '\\') {
                            int character = this.readEscapedCharacter();
                            if (Character.isBmpCodePoint(character)) {
                                result = Character.valueOf((char)character);
                                continue;
                            }
                            throw new IllegalStateException("Supplementary char cannot be stored in Character");
                        }
                        result = Character.valueOf(marker);
                        continue;
                    }
                    if (marker != '\\') continue;
                    this.readRaw();
                }
                break;
            }
            case '\'': {
                while (true) {
                    if ((marker = this.readRaw()) == '\'') {
                        if (this.readRaw() == '\'') {
                            if (result != null) continue;
                            result = Character.valueOf('\'');
                            continue;
                        }
                        this.setReuseBuffer();
                        break block0;
                    }
                    if (result != null) continue;
                    result = Character.valueOf(marker);
                }
            }
            default: {
                if (this.isNullSkippedFromMarker(marker)) {
                    return null;
                }
                while (!(this.isEndMarker(marker) || marker == ',' && !this.bracketOpened || this.skipComments(owner, marker, false))) {
                    if (result == null) {
                        result = Character.valueOf(marker);
                    }
                    marker = this.readRaw();
                }
                break block0;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readEscapedCharacter() {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            int n;
            char marker = this.readRaw();
            switch (marker) {
                case '0': {
                    n = 0;
                    break;
                }
                case 'a': {
                    n = 7;
                    break;
                }
                case 'b': {
                    n = 8;
                    break;
                }
                case 't': {
                    n = 9;
                    break;
                }
                case 'n': {
                    n = 10;
                    break;
                }
                case 'v': {
                    n = 11;
                    break;
                }
                case 'f': {
                    n = 12;
                    break;
                }
                case 'r': {
                    n = 13;
                    break;
                }
                case 'e': {
                    n = 27;
                    break;
                }
                case ' ': {
                    n = 32;
                    break;
                }
                case '\"': {
                    n = 34;
                    break;
                }
                case '\\': {
                    n = 92;
                    break;
                }
                case 'N': {
                    n = 133;
                    break;
                }
                case '_': {
                    n = 160;
                    break;
                }
                case 'L': {
                    n = 8232;
                    break;
                }
                case 'P': {
                    n = 8233;
                    break;
                }
                case 'x': {
                    n = this.readHexChar(2);
                    break;
                }
                case 'u': {
                    n = this.readHexChar(4);
                    break;
                }
                case 'U': {
                    n = this.readHexChar(8);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid escape character: \\" + marker);
                }
            }
            return n;
        }
    }

    private int readHexChar(int size) {
        StringBuilder hex = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            char character = this.readRaw();
            if (this.isEndMarker(character)) {
                throw new IllegalStateException("Got new line while reading hex char");
            }
            hex.append(character);
        }
        return Integer.parseInt(hex.toString(), 16);
    }

    private String readStringFromMarker(@Nullable Field owner, char marker, boolean nodeName) {
        StringBuilder result = new StringBuilder();
        switch (marker) {
            case '\"': {
                if (owner != null && !nodeName && this.yamlSerializable != null) {
                    this.yamlSerializable.saveStringStyle(owner, YamlWriter.StringStyle.DOUBLE_QUOTED);
                }
                int newLineCount = 0;
                while ((marker = this.readRaw()) != '\"') {
                    if (this.isEndMarker(marker)) {
                        if (nodeName) {
                            throw new IllegalStateException("Got a new line in node name: " + result);
                        }
                        this.readRawIgnoreEmpty();
                        this.setReuseBuffer();
                        ++newLineCount;
                        continue;
                    }
                    if (newLineCount == 1) {
                        result.append(' ');
                    } else {
                        for (int i = 1; i < newLineCount; ++i) {
                            result.append('\n');
                        }
                    }
                    newLineCount = 0;
                    if (marker == '\\') {
                        int character = this.readEscapedCharacter();
                        if (Character.isBmpCodePoint(character)) {
                            result.append((char)character);
                            continue;
                        }
                        if (Character.isValidCodePoint(character)) {
                            result.append(Character.highSurrogate(character));
                            result.append(Character.lowSurrogate(character));
                            continue;
                        }
                        throw new IllegalArgumentException(String.format("Not a valid Unicode code point: 0x%X", character));
                    }
                    result.append(marker);
                }
                if (!nodeName || (marker = this.readRawIgnoreEmpty()) == ':') break;
                throw new IllegalStateException("Got illegal marker when reading node name: " + marker + " for " + result);
            }
            case '\'': {
                if (owner != null && !nodeName && this.yamlSerializable != null) {
                    this.yamlSerializable.saveStringStyle(owner, YamlWriter.StringStyle.SINGLE_QUOTED);
                }
                int newLineCount = 0;
                while (true) {
                    if (this.isEndMarker(marker = this.readRaw())) {
                        if (nodeName) {
                            throw new IllegalStateException("Got a new line in node name: " + result);
                        }
                        this.readRawIgnoreEmpty();
                        this.setReuseBuffer();
                        ++newLineCount;
                        continue;
                    }
                    if (newLineCount == 1) {
                        result.append(' ');
                    } else {
                        for (int i = 1; i < newLineCount; ++i) {
                            result.append('\n');
                        }
                    }
                    newLineCount = 0;
                    if (marker == '\'') {
                        if (this.readRaw() == '\'') {
                            result.append('\'');
                            continue;
                        }
                        break;
                    }
                    result.append(marker);
                }
                this.setReuseBuffer();
                if (!nodeName || (marker = this.readRawIgnoreEmpty()) == ':') break;
                throw new IllegalStateException("Got illegal marker when reading node name: " + marker + " for " + result);
            }
            default: {
                if (marker == '#') {
                    this.skipComments(owner, marker, false);
                    break;
                }
                if (!(nodeName || marker != '|' && marker != '>')) {
                    this.readMultilineStringFromMarker(owner, marker, result);
                    break;
                }
                if (this.spacesBuffer != null && this.spacesBuffer.length() != 0) {
                    this.spacesBuffer.setLength(0);
                }
                while (nodeName ? marker != ':' : !(this.isEndMarker(marker) || marker == ',' && !this.bracketOpened || Character.isWhitespace(marker) && this.skipComments(owner, this.readRaw(), true))) {
                    if (nodeName && this.isEndMarker(marker)) {
                        throw new IllegalStateException("Got a new line in node name: " + result);
                    }
                    if (Character.isWhitespace(marker)) {
                        if (this.spacesBuffer == null) {
                            this.spacesBuffer = new StringBuilder(4);
                        }
                        this.spacesBuffer.append(marker);
                    } else {
                        if (this.spacesBuffer != null && this.spacesBuffer.length() != 0) {
                            result.append((CharSequence)this.spacesBuffer);
                            this.spacesBuffer.setLength(0);
                        }
                        result.append(marker);
                    }
                    marker = this.readRaw();
                }
                if (nodeName) break;
                String string = result.toString();
                if (string.equals("null")) {
                    return null;
                }
                if (this.yamlSerializable != null && owner != null) {
                    this.yamlSerializable.saveStringStyle(owner, YamlWriter.StringStyle.NOT_QUOTED);
                }
                return string;
            }
        }
        return result.toString();
    }

    private void readMultilineStringFromMarker(@Nullable Field owner, char marker, StringBuilder result) {
        int i;
        boolean bl;
        switch (marker) {
            case '>': {
                if (this.yamlSerializable != null && owner != null) {
                    this.yamlSerializable.saveStringStyle(owner, YamlWriter.StringStyle.MULTILINE_FOLDED_AUTO_CLIPPED);
                }
                bl = false;
                break;
            }
            case '|': {
                if (this.yamlSerializable != null && owner != null) {
                    this.yamlSerializable.saveStringStyle(owner, YamlWriter.StringStyle.MULTILINE_LITERAL_AUTO_CLIPPED);
                }
                bl = true;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid multiline marker: " + marker);
            }
        }
        boolean keepNewLines = bl;
        int chomping = 10;
        marker = this.readRawIgnoreEmpty();
        if (marker == '+' || marker == '-') {
            chomping = marker;
            marker = this.readRawIgnoreEmpty();
        }
        int fixedIndent = 0;
        if (marker >= '1' && marker <= '9') {
            fixedIndent = marker - 48;
            marker = this.readRawIgnoreEmpty();
        }
        if (marker != '\n') {
            throw new IllegalStateException("Got illegal marker while reading multiline string: " + marker);
        }
        marker = this.readRawIgnoreEmpty();
        int indentOffset = this.currentIndent - this.nodeIndent;
        if (indentOffset == 0) {
            throw new IllegalStateException("String should be indented");
        }
        if (fixedIndent == 0) {
            fixedIndent = indentOffset;
        }
        if (fixedIndent > indentOffset) {
            throw new IllegalStateException("Indentation marker does not match current indent offset: " + indentOffset);
        }
        int newLineCount = 0;
        boolean firstLine = true;
        while (indentOffset >= fixedIndent) {
            if (marker == '\n') {
                ++newLineCount;
                marker = this.readRawIgnoreEmpty();
                indentOffset = (marker == '\n' ? this.newLineIndent : this.currentIndent) - this.nodeIndent;
                continue;
            }
            if (!keepNewLines && newLineCount > 0 && newLineCount == 1) {
                result.append(' ');
            }
            for (i = newLineCount - (keepNewLines ? 0 : 1) - 1; i >= 0; --i) {
                result.append('\n');
            }
            if (newLineCount != 0 || firstLine) {
                for (i = indentOffset - fixedIndent - 1; i >= 0; --i) {
                    result.append(' ');
                }
                firstLine = false;
            }
            newLineCount = 0;
            result.append(marker);
            marker = this.readRaw();
        }
        switch (chomping) {
            case 45: {
                newLineCount = 0;
                break;
            }
            case 43: {
                break;
            }
            default: {
                newLineCount = 1;
            }
        }
        for (i = 0; i < newLineCount; ++i) {
            result.append('\n');
        }
        this.setReuseBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skipGuessingType(@Nullable Field owner) {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            this.skipGuessingTypeFromMarker(owner, this.readRawIgnoreEmpty());
        }
    }

    private void skipGuessingTypeFromMarker(@Nullable Field owner, char marker) {
        switch (marker) {
            case '\n': {
                char nextMarker = this.readRawIgnoreEmpty();
                this.setReuseBuffer();
                if (nextMarker == '-') {
                    this.skipCollectionFromMarker(owner, marker);
                    break;
                }
                this.skipMapFromMarker(owner, marker);
                break;
            }
            case '-': {
                this.setReuseBuffer();
                this.skipCollectionFromMarker(owner, '\n');
                break;
            }
            case '[': {
                this.skipCollectionFromMarker(owner, marker);
                break;
            }
            case '{': {
                this.skipMapFromMarker(owner, marker);
                break;
            }
            case '\"': 
            case '\'': 
            case '>': 
            case '|': {
                this.skipStringFromMarker(owner, marker, false);
                break;
            }
            default: {
                if (this.isNullSkippedFromMarker(marker)) {
                    return;
                }
                this.setSeekFromMarker(marker);
                String string = this.readStringFromMarker(owner, marker, false);
                if (string != null && (string.endsWith(":") || string.endsWith(": ") || string.contains(": "))) {
                    this.unsetSeek();
                    this.unsetTempRestoreNewLine();
                    this.skipMapFromMarker(owner, '\n');
                    break;
                }
                this.clearSeek();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skipCollection(@Nullable Field owner) {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            this.skipCollectionFromMarker(owner, this.readRawIgnoreEmpty());
        }
    }

    @SuppressFBWarnings(value={"SA_FIELD_SELF_COMPARISON"})
    private void skipCollectionFromMarker(@Nullable Field owner, char marker) {
        if (this.skipComments(owner, marker, false)) {
            marker = (char)10;
        }
        switch (marker) {
            case '[': {
                char nextMarker = this.readRawIgnoreEmptyAndNewLines();
                while (nextMarker != ']') {
                    this.skipGuessingType(owner);
                    nextMarker = this.readRawIgnoreEmptyAndNewLines();
                }
                break;
            }
            case '\n': {
                this.skipComments(owner, this.readRawIgnoreEmpty(), true);
                char nextMarker = this.readRawIgnoreEmpty();
                if (nextMarker != '-') {
                    throw new IllegalStateException("Got unknown marker when reading list: " + nextMarker);
                }
            }
            case '-': {
                this.nodeIndent = this.currentIndent;
                char nextMarker = '-';
                int correctIndent = this.currentIndent;
                while (nextMarker == '-' && correctIndent == this.currentIndent) {
                    this.setTempRestoreNewLine();
                    this.skipGuessingType(owner);
                    this.unsetTempRestoreNewLine();
                    nextMarker = this.readRawIgnoreEmptyAndNewLines();
                    if (!this.skipComments(owner, nextMarker, false)) continue;
                    nextMarker = this.readRawIgnoreEmptyAndNewLines();
                }
                this.setReuseBuffer();
                break;
            }
            default: {
                if (this.isNullSkippedFromMarker(marker)) break;
                throw new IllegalStateException("Got unknown marker when reading list: " + marker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skipMap(@Nullable Field owner) {
        boolean startOfFile = this.startOfFile;
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            char marker = this.readRawIgnoreEmpty();
            if (startOfFile) {
                this.setTempRestoreNewLine();
            }
            this.skipMapFromMarker(owner, marker);
        }
    }

    @SuppressFBWarnings(value={"SA_FIELD_SELF_COMPARISON"})
    private void skipMapFromMarker(@Nullable Field owner, char marker) {
        char nextMarker;
        if (this.skipComments(owner, marker, false)) {
            marker = (char)10;
        }
        if (this.tempRestoreNewLine) {
            nextMarker = marker;
            marker = (char)10;
            this.unsetTempRestoreNewLine();
        } else {
            nextMarker = this.readRawIgnoreEmptyAndNewLines();
        }
        boolean previousBracketOpened = this.bracketOpened;
        switch (marker) {
            case '{': {
                this.bracketOpened = true;
                while (nextMarker != '}') {
                    this.skipStringFromMarker(owner, nextMarker, true);
                    this.skipGuessingType(owner);
                    nextMarker = this.readRawIgnoreEmptyAndNewLines();
                }
                this.bracketOpened = previousBracketOpened;
                break;
            }
            case '\n': {
                this.bracketOpened = false;
                int correctIndent = this.currentIndent;
                while (nextMarker != '\u0000' && correctIndent == this.currentIndent) {
                    this.skipStringFromMarker(owner, nextMarker, true);
                    this.skipGuessingType(owner);
                    nextMarker = this.readRawIgnoreEmptyAndNewLines();
                    if (!this.skipComments(owner, nextMarker, false)) continue;
                    nextMarker = this.readRawIgnoreEmptyAndNewLines();
                }
                this.setReuseBuffer();
                this.bracketOpened = previousBracketOpened;
                break;
            }
            default: {
                if (this.isNullSkippedFromMarker(marker)) break;
                throw new IllegalStateException("Got unknown marker when reading map: " + marker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skipString(@Nullable Field owner) {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            this.skipStringFromMarker(owner, this.readRawIgnoreEmpty(), false);
        }
    }

    private void skipStringFromMarker(@Nullable Field owner, char marker, boolean nodeName) {
        switch (marker) {
            case '\"': {
                while ((marker = this.readRaw()) != '\"') {
                    if (marker == '\\') {
                        this.readRaw();
                        continue;
                    }
                    if (!nodeName || !this.isEndMarker(marker)) continue;
                    throw new IllegalStateException("Got a new line in node name.");
                }
                if (!nodeName || (marker = this.readRawIgnoreEmpty()) == ':') break;
                throw new IllegalStateException("Got illegal marker when reading node name: " + marker);
            }
            case '\'': {
                do {
                    marker = this.readRaw();
                    if (!nodeName || !this.isEndMarker(marker)) continue;
                    throw new IllegalStateException("Got a new line in node name.");
                } while (marker != '\'' || this.readRaw() == '\'');
                if (!nodeName || (marker = this.readRawIgnoreEmpty()) == ':') break;
                throw new IllegalStateException("Got illegal marker when reading node name: " + marker);
            }
            default: {
                if (marker == '#') {
                    this.skipComments(owner, marker, false);
                    break;
                }
                if (!(nodeName || marker != '|' && marker != '>')) {
                    this.skipMultilineStringFromMarker(marker);
                    break;
                }
                while (nodeName ? marker != ':' : !this.isEndMarker(marker) && (marker != ',' || this.bracketOpened) && !this.skipComments(owner, marker, false)) {
                    if (nodeName && this.isEndMarker(marker)) {
                        throw new IllegalStateException("Got a new line in node name.");
                    }
                    marker = this.readRaw();
                }
                break block0;
            }
        }
    }

    private void skipMultilineStringFromMarker(char marker) {
        if (marker != '>' && marker != '|') {
            throw new IllegalStateException("Invalid multiline marker: " + marker);
        }
        marker = this.readRawIgnoreEmpty();
        if (marker == '+' || marker == '-') {
            marker = this.readRawIgnoreEmpty();
        }
        int fixedIndent = 0;
        if (marker >= '1' && marker <= '9') {
            fixedIndent = marker - 48;
            marker = this.readRawIgnoreEmpty();
        }
        if (marker != '\n') {
            throw new IllegalStateException("Got illegal marker while skipping multiline string: " + marker);
        }
        marker = this.readRawIgnoreEmpty();
        int indentOffset = this.currentIndent - this.nodeIndent;
        if (indentOffset == 0) {
            throw new IllegalStateException("String should be indented");
        }
        if (fixedIndent == 0) {
            fixedIndent = indentOffset;
        }
        if (fixedIndent > indentOffset) {
            throw new IllegalStateException("Indentation marker does not match current indent offset: " + indentOffset);
        }
        while (fixedIndent <= indentOffset) {
            if (marker == '\n') {
                marker = this.readRawIgnoreEmpty();
                indentOffset = (marker == '\n' ? this.newLineIndent : this.currentIndent) - this.nodeIndent;
                continue;
            }
            marker = this.readRaw();
        }
        this.setReuseBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean skipComments(@Nullable Field owner, char marker, boolean reuse) {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            if (marker == '#') {
                while (!this.isEndMarker(this.readRaw())) {
                }
                this.readRawIgnoreEmptyAndNewLines();
                this.setReuseBuffer();
                return true;
            }
            if (reuse) {
                this.setReuseBuffer();
            }
            return false;
        }
    }

    protected boolean isEndMarker(char marker) {
        return marker == '\u0000' || marker == '\n';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSeek() {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            this.seekIndent = this.currentIndent;
        }
        super.setSeek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSeekFromMarker(char marker) {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            this.seekIndent = this.currentIndent - 1;
        }
        super.setSeekFromMarker(marker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsetSeek() {
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            this.currentIndent = this.seekIndent;
        }
        super.unsetSeek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char readRaw() {
        this.startOfFile = false;
        YamlReader yamlReader = this;
        synchronized (yamlReader) {
            boolean shouldIndent = !this.isReuseBuffer();
            char character = super.readRaw();
            if (character == '\n') {
                this.newLineIndent = this.currentIndent + 1;
                this.currentIndent = 0;
            } else if (shouldIndent) {
                ++this.currentIndent;
            }
            return character;
        }
    }

    private boolean isNullSkippedFromMarker(char marker) {
        char endMarker;
        this.setSeek();
        if (marker == 'n' && this.readRaw() == 'u' && this.readRaw() == 'l' && this.readRaw() == 'l' && (this.isEndMarker(endMarker = this.readRawIgnoreEmpty()) || endMarker == ',' && this.bracketOpened)) {
            this.clearSeek();
            return true;
        }
        this.unsetSeek();
        return false;
    }

    private boolean skipChar(char expected) {
        if (expected == this.readRawIgnoreEmptyAndNewLines()) {
            return true;
        }
        this.setReuseBuffer();
        return false;
    }

    private void setTempRestoreNewLine() {
        this.tempRestoreNewLine = true;
    }

    private void unsetTempRestoreNewLine() {
        this.tempRestoreNewLine = false;
    }
}

