/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.fastmotd.thirdparty.serializer.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public class GenericUtils {
    public static Class<?> unwrapClassParameterizedType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type type2 = parameterizedType.getRawType();
            if (type2 instanceof Class) {
                Class clazz = (Class)type2;
                return clazz;
            }
            throw new IllegalArgumentException("Can only unwrap Class<?> from ParameterizedType");
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        throw new IllegalArgumentException("Can only unwrap Class<?> or ParameterizedType of Class<?>");
    }

    public static Type getParameterTypeFromSuperclass(Class<?> parent, Type type, Type superclass, int searchIndex) {
        Type superclassType = GenericUtils.getParameterTypeOrNull(parent, superclass, searchIndex);
        if (superclassType instanceof TypeVariable) {
            ParameterizedType parameterizedType;
            int index;
            TypeVariable typeVariable = (TypeVariable)superclassType;
            if (type instanceof ParameterizedType && (index = GenericUtils.getParameterIndex(((Class)(parameterizedType = (ParameterizedType)type).getRawType()).getTypeParameters(), typeVariable)) != -1) {
                return parameterizedType.getActualTypeArguments()[index];
            }
        }
        return superclassType;
    }

    public static Type getParameterType(Class<?> parent, Type type, int index) {
        Type parameterType = GenericUtils.getParameterTypeOrNull(parent, type, index);
        return parameterType == null ? Object.class : parameterType;
    }

    private static Type getParameterTypeOrNull(Class<?> parent, Type type, int index) {
        ParameterizedType parameterizedType;
        if (type == null) {
            return null;
        }
        Class clazz = null;
        if (type instanceof ParameterizedType && (clazz = (Class)(parameterizedType = (ParameterizedType)type).getRawType()).equals(parent)) {
            return parameterizedType.getActualTypeArguments()[index];
        }
        if (type instanceof Class) {
            Class typeClazz;
            clazz = typeClazz = (Class)type;
        }
        if (clazz != null) {
            Type superclassType = GenericUtils.getParameterTypeFromSuperclass(parent, type, clazz.getGenericSuperclass(), index);
            if (superclassType != null) {
                return superclassType;
            }
            for (Type genericInterface : clazz.getGenericInterfaces()) {
                Type genericInterfaceType = GenericUtils.getParameterTypeFromSuperclass(parent, type, genericInterface, index);
                if (genericInterfaceType == null) continue;
                return genericInterfaceType;
            }
        }
        return null;
    }

    public static int getParameterIndex(TypeVariable<?>[] variables, TypeVariable<?> expected) {
        for (int i = 0; i < variables.length; ++i) {
            if (!expected.equals(variables[i])) continue;
            return i;
        }
        return -1;
    }
}

