/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.fastmotd.utils;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ByteBufCopyThreadLocal
extends ThreadLocal<ByteBuf> {
    private final List<ByteBuf> byteBuffers = new LinkedList<ByteBuf>();
    private final ListIterator<ByteBuf> byteBufferIterator;

    public ByteBufCopyThreadLocal(ByteBuf from) {
        for (int i = 0; i < Runtime.getRuntime().availableProcessors(); ++i) {
            this.byteBuffers.add(from.copy());
        }
        this.byteBufferIterator = this.byteBuffers.listIterator();
    }

    @Override
    protected ByteBuf initialValue() {
        return this.byteBufferIterator.next();
    }

    public void release() {
        for (ByteBuf byteBuffer : this.byteBuffers) {
            if (byteBuffer.refCnt() == 0) continue;
            byteBuffer.release();
        }
    }
}

