/*
 * Decompiled with CFR 0.152.
 */
package mc.ardacraft.aclodgrabber;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.InputStream;
import java.net.HttpURLConnection;
import mc.ardacraft.aclodgrabber.config.ModConfig;
import mc.ardacraft.aclodgrabber.file.FileManager;
import mc.ardacraft.aclodgrabber.network.NetworkManager;
import mc.ardacraft.aclodgrabber.screen.DownloadProgressScreen;
import mc.ardacraft.aclodgrabber.screen.LodPromptScreen;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_442;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLODGrabber
implements ModInitializer,
ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"aclodgrabber");
    private static ACLODGrabber instance;
    private static ModConfig config;
    private static boolean isCurrentlyDownloading;
    private boolean promptSuppressedUntilRestart = false;

    public static ACLODGrabber getInstance() {
        return instance;
    }

    public void onInitialize() {
        LOGGER.info("Initializing ACLODGrabber...");
        instance = this;
        config = ModConfig.load();
        this.registerCommands();
    }

    public void onInitializeClient() {
        this.registerCommands();
    }

    private void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"resetLODs").executes(context -> {
            try {
                config.reset();
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"command.resetLODs.success"));
                return 1;
            }
            catch (Exception e) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43471((String)"command.resetLODs.error"));
                return 0;
            }
        })));
    }

    public void checkForUpdates(class_310 client) {
        if (this.promptSuppressedUntilRestart) {
            return;
        }
        new Thread(() -> {
            try {
                long serverLastModified = NetworkManager.getServerLastModified();
                long lastDownloadTime = ACLODGrabber.config.lastDownloadTime;
                LOGGER.info("Update check - Server: {}, LastDownload: {}", (Object)serverLastModified, (Object)lastDownloadTime);
                boolean shouldPrompt = false;
                if (serverLastModified > lastDownloadTime || lastDownloadTime == 0L) {
                    shouldPrompt = true;
                    if (lastDownloadTime == 0L) {
                        LOGGER.info("Should prompt: First time download (lastDownloadTime = 0)");
                    } else {
                        LOGGER.info("Should prompt: Server version {} > last download time {}", (Object)serverLastModified, (Object)lastDownloadTime);
                    }
                } else {
                    LOGGER.info("No update needed: Server version {} <= last download time {}", (Object)serverLastModified, (Object)lastDownloadTime);
                }
                if (shouldPrompt) {
                    this.promptForUpdate(client, (int)(serverLastModified / 1000L));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to check for updates", (Throwable)e);
            }
        }).start();
    }

    private void promptForUpdate(class_310 client, int latestVersion) {
        LOGGER.info("promptForUpdate called with version: {}", (Object)latestVersion);
        if (this.promptSuppressedUntilRestart) {
            LOGGER.info("Prompt suppressed - not showing screen");
            return;
        }
        LOGGER.info("Setting screen to LodPromptScreen");
        client.execute(() -> client.method_1507((class_437)new LodPromptScreen()));
    }

    public void acceptUpdate() {
        this.onAcceptUpdate(class_310.method_1551(), (int)(ACLODGrabber.config.lastDownloadTime / 1000L));
    }

    public void notNowUpdate() {
        this.onNotNowUpdate(class_310.method_1551());
    }

    public void initiateDownload() {
        this.initiateDownloadInternal(class_310.method_1551());
    }

    public void onDownloadComplete() {
        LOGGER.info("Download and installation complete!");
    }

    public void retryDownload() {
        LOGGER.info("Retrying download...");
        this.initiateDownloadInternal(class_310.method_1551());
    }

    public void cancelDownload() {
        isCurrentlyDownloading = false;
        LOGGER.info("Download cancelled by user");
    }

    private void onAcceptUpdate(class_310 client, int latestVersion) {
        this.initiateDownloadInternal(client);
    }

    private void onNotNowUpdate(class_310 client) {
        this.promptSuppressedUntilRestart = true;
        client.method_1507((class_437)new class_442());
    }

    private void initiateDownloadInternal(class_310 client) {
        if (isCurrentlyDownloading) {
            LOGGER.warn("A download is already in progress. Ignored new request.");
            return;
        }
        client.execute(() -> {
            DownloadProgressScreen downloadScreen = new DownloadProgressScreen();
            client.method_1507((class_437)downloadScreen);
            this.downloadAndInstallLODs(client, downloadScreen);
        });
    }

    private void downloadAndInstallLODs(class_310 client, DownloadProgressScreen downloadScreen) {
        isCurrentlyDownloading = true;
        new Thread(() -> {
            try {
                downloadScreen.setProgress(0, "");
                HttpURLConnection connection = NetworkManager.createDownloadConnection();
                long contentLength = connection.getContentLengthLong();
                long serverLastModified = connection.getLastModified();
                downloadScreen.setServerLastModified(serverLastModified);
                try (InputStream inputStream = connection.getInputStream();){
                    FileManager.extractZipFile(inputStream, (bytesDownloaded, extractionProgress) -> client.execute(() -> {
                        class_437 patt0$temp = client.field_1755;
                        if (patt0$temp instanceof DownloadProgressScreen) {
                            DownloadProgressScreen dps = (DownloadProgressScreen)patt0$temp;
                            if (bytesDownloaded >= 0L) {
                                dps.updateDownloadProgress(bytesDownloaded, contentLength);
                            } else if (extractionProgress >= 0) {
                                dps.setProgress(100, "\u00a7e" + class_2561.method_43471((String)"screen.aclodgrabber.download.extracting").getString());
                            }
                        }
                    }));
                }
                ACLODGrabber.config.lastDownloadTime = System.currentTimeMillis();
                config.save();
                client.execute(() -> {
                    class_437 patt0$temp = client.field_1755;
                    if (patt0$temp instanceof DownloadProgressScreen) {
                        DownloadProgressScreen dps = (DownloadProgressScreen)patt0$temp;
                        dps.setProgress(100, class_2561.method_43471((String)"screen.aclodgrabber.download.complete").getString());
                        dps.onDownloadComplete();
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Download failed", (Throwable)e);
                client.execute(() -> {
                    class_437 patt0$temp = client.field_1755;
                    if (patt0$temp instanceof DownloadProgressScreen) {
                        DownloadProgressScreen dps = (DownloadProgressScreen)patt0$temp;
                        dps.markDownloadFailed();
                    }
                });
            }
            finally {
                isCurrentlyDownloading = false;
            }
        }).start();
    }

    static {
        isCurrentlyDownloading = false;
        LOGGER.info("Registering CLIENT_STARTED event");
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            LOGGER.info("CLIENT_STARTED event triggered");
            ACLODGrabber grabber = ACLODGrabber.getInstance();
            if (grabber != null) {
                LOGGER.info("ACLODGrabber instance found, calling checkForUpdates");
                grabber.checkForUpdates(client);
            } else {
                LOGGER.warn("ACLODGrabber instance is null!");
            }
        });
    }
}

