/*
 * Decompiled with CFR 0.152.
 */
package mc.ardacraft.aclodgrabber.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"aclodgrabber");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "ACLODGrabber/config.json");
    public long lastDownloadTime = 0L;

    public static ModConfig load() {
        ModConfig modConfig;
        if (!CONFIG_FILE.exists()) {
            return new ModConfig();
        }
        FileReader reader = new FileReader(CONFIG_FILE);
        try {
            modConfig = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Failed to load config", (Throwable)e);
                return new ModConfig();
            }
        }
        reader.close();
        return modConfig;
    }

    public void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public void reset() {
        this.lastDownloadTime = 0L;
        this.save();
    }
}

