/*
 * Decompiled with CFR 0.152.
 */
package mc.ardacraft.aclodgrabber.file;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"aclodgrabber.file");
    private static final String DH_FOLDER = "Distant_Horizons_server_data";
    private static final long MIN_FREE_SPACE_BYTES = 0x280000000L;

    public static Path getMinecraftDirectory() {
        return FabricLoader.getInstance().getGameDir();
    }

    public static boolean hasEnoughSpace() {
        try {
            Path gameDir = FileManager.getMinecraftDirectory();
            long freeSpace = Files.getFileStore(gameDir).getUsableSpace();
            return freeSpace >= 0x280000000L;
        }
        catch (IOException e) {
            LOGGER.warn("Could not check available disk space", (Throwable)e);
            return true;
        }
    }

    public static Path getLODsDirectory() {
        return FileManager.getMinecraftDirectory().resolve(DH_FOLDER);
    }

    public static boolean hasExistingLODs() {
        return Files.exists(FileManager.getLODsDirectory(), new LinkOption[0]);
    }

    public static void deleteExistingLODs() throws IOException {
        Path lodDir = FileManager.getLODsDirectory();
        if (Files.exists(lodDir, new LinkOption[0])) {
            Files.walk(lodDir, new FileVisitOption[0]).sorted((a, b) -> b.compareTo((Path)a)).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to delete file: " + String.valueOf(path), (Throwable)e);
                }
            });
        }
    }

    public static void extractZipFile(InputStream zipStream, DownloadProgressCallback callback) throws IOException {
        if (!FileManager.hasEnoughSpace()) {
            throw new IOException("Not enough disk space. At least 10GB required.");
        }
        Path tempFile = null;
        try {
            tempFile = Files.createTempFile("aclodgrabber", ".zip", new FileAttribute[0]);
            LOGGER.debug("Created temporary file: {}", (Object)tempFile);
            try (FileOutputStream fos = new FileOutputStream(tempFile.toFile());){
                int bytesRead;
                byte[] buffer = new byte[8192];
                long totalBytes = 0L;
                while ((bytesRead = zipStream.read(buffer)) != -1) {
                    fos.write(buffer, 0, bytesRead);
                    totalBytes += (long)bytesRead;
                    if (callback == null) continue;
                    callback.onProgress(totalBytes, -1);
                }
                LOGGER.debug("Downloaded {} bytes to temp file", (Object)totalBytes);
            }
            try (ZipFile zipFile = new ZipFile(tempFile.toFile());){
                Enumeration entries = zipFile.getEntries();
                int processedEntries = 0;
                int totalEntries = 0;
                while (entries.hasMoreElements()) {
                    entries.nextElement();
                    ++totalEntries;
                }
                LOGGER.debug("Found {} entries in ZIP file", (Object)totalEntries);
                entries = zipFile.getEntries();
                while (entries.hasMoreElements()) {
                    ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                    if (!entry.isDirectory()) {
                        Path targetPath = FileManager.getMinecraftDirectory().resolve(entry.getName());
                        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                        try (InputStream entryStream = zipFile.getInputStream(entry);){
                            Files.copy(entryStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    ++processedEntries;
                    if (callback == null) continue;
                    callback.onProgress(-1L, (int)((double)processedEntries * 100.0 / (double)totalEntries));
                }
                LOGGER.info("Successfully extracted {} entries", (Object)processedEntries);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to extract ZIP file", (Throwable)e);
            throw e;
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.deleteIfExists(tempFile);
                    LOGGER.debug("Cleaned up temporary file: {}", (Object)tempFile);
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to delete temporary file: {}", (Object)tempFile, (Object)e);
                }
            }
        }
    }

    public static interface DownloadProgressCallback {
        public void onProgress(long var1, int var3);
    }
}

